/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11DocumentScannerImpl
extends XMLDocumentScannerImpl {
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    protected int scanContent() throws IOException, XNIException {
        XMLString content = this.fString;
        int c = this.fEntityScanner.scanContent(content);
        if (c == 13 || c == 133 || c == 8232) {
            this.fEntityScanner.scanChar();
            this.fStringBuffer.clear();
            this.fStringBuffer.append(this.fString);
            this.fStringBuffer.append((char)c);
            content = this.fStringBuffer;
            c = -1;
        }
        if (this.fDocumentHandler != null && content.length > 0) {
            this.fDocumentHandler.characters(content, null);
        }
        if (c == 93 && this.fString.length == 0) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                this.fStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    this.fStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            if (this.fDocumentHandler != null && this.fStringBuffer.length != 0) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
            }
            this.fInScanContent = false;
            c = -1;
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean scanAttributeValue(XMLString value, XMLString nonNormalizedValue, String atName, boolean checkEntities, String eleName) throws IOException, XNIException {
        int quote;
        block28: {
            quote = this.fEntityScanner.peekChar();
            if (quote != 39 && quote != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{eleName, atName});
            }
            this.fEntityScanner.scanChar();
            int entityDepth = this.fEntityDepth;
            int c = this.fEntityScanner.scanLiteral(quote, value);
            int fromIndex = 0;
            if (c == quote && (fromIndex = this.isUnchangedByNormalization(value)) == -1) {
                nonNormalizedValue.setValues(value);
                int cquote = this.fEntityScanner.scanChar();
                if (cquote != quote) {
                    this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
                }
                return true;
            }
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(value);
            this.normalizeWhitespace(value, fromIndex);
            if (c == quote) break block28;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                block31: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block29: {
                                        String entityName;
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block30: {
                                                                int ch;
                                                                this.fStringBuffer.append(value);
                                                                if (c != 38) break block29;
                                                                this.fEntityScanner.skipChar(38);
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('&');
                                                                }
                                                                if (!this.fEntityScanner.skipChar(35)) break block30;
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('#');
                                                                }
                                                                if ((ch = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) == -1) {
                                                                    // empty if block
                                                                }
                                                                break block31;
                                                            }
                                                            entityName = this.fEntityScanner.scanName();
                                                            if (entityName == null) {
                                                                this.reportFatalError("NameRequiredInReference", null);
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(entityName);
                                                            }
                                                            if (!this.fEntityScanner.skipChar(59)) {
                                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{entityName});
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(';');
                                                            }
                                                            if (entityName != fAmpSymbol) break block32;
                                                            this.fStringBuffer.append('&');
                                                            break block31;
                                                        }
                                                        if (entityName != fAposSymbol) break block33;
                                                        this.fStringBuffer.append('\'');
                                                        break block31;
                                                    }
                                                    if (entityName != fLtSymbol) break block34;
                                                    this.fStringBuffer.append('<');
                                                    break block31;
                                                }
                                                if (entityName != fGtSymbol) break block35;
                                                this.fStringBuffer.append('>');
                                                break block31;
                                            }
                                            if (entityName != fQuotSymbol) break block36;
                                            this.fStringBuffer.append('\"');
                                            break block31;
                                        }
                                        if (this.fEntityManager.isExternalEntity(entityName)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{entityName});
                                            break block31;
                                        } else {
                                            if (!this.fEntityManager.isDeclaredEntity(entityName)) {
                                                if (checkEntities) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{entityName}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{entityName});
                                                }
                                            }
                                            this.fEntityManager.startEntity(entityName, true);
                                        }
                                        break block31;
                                    }
                                    if (c != 60) break block37;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{eleName, atName});
                                    this.fEntityScanner.scanChar();
                                    if (entityDepth == this.fEntityDepth) {
                                        this.fStringBuffer2.append((char)c);
                                    }
                                    break block31;
                                }
                                if (c != 37 && c != 93) break block38;
                                this.fEntityScanner.scanChar();
                                this.fStringBuffer.append((char)c);
                                if (entityDepth == this.fEntityDepth) {
                                    this.fStringBuffer2.append((char)c);
                                }
                                break block31;
                            }
                            if (c != 10 && c != 13 && c != 133 && c != 8232) break block39;
                            this.fEntityScanner.scanChar();
                            this.fStringBuffer.append(' ');
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block31;
                        }
                        if (c == -1 || !XMLChar.isHighSurrogate(c)) break block40;
                        this.fStringBuffer3.clear();
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            this.fStringBuffer.append(this.fStringBuffer3);
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block31;
                    }
                    if (c != -1 && this.isInvalidLiteral(c)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{eleName, atName, Integer.toString(c, 16)});
                        this.fEntityScanner.scanChar();
                        if (entityDepth == this.fEntityDepth) {
                            this.fStringBuffer2.append((char)c);
                        }
                    }
                }
                c = this.fEntityScanner.scanLiteral(quote, value);
                if (entityDepth == this.fEntityDepth) {
                    this.fStringBuffer2.append(value);
                }
                this.normalizeWhitespace(value);
            } while (c != quote || entityDepth != this.fEntityDepth);
            this.fStringBuffer.append(value);
            value.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        nonNormalizedValue.setValues(this.fStringBuffer2);
        int cquote = this.fEntityScanner.scanChar();
        if (cquote != quote) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
        }
        return nonNormalizedValue.equals(value.ch, value.offset, value.length);
    }

    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar()) == 32 || c == 10 || c == 13 || c == 133 || c == 8232) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            value.ch[i] = 32;
        }
    }

    protected void normalizeWhitespace(XMLString value, int fromIndex) {
        int end = value.offset + value.length;
        for (int i = value.offset + fromIndex; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            value.ch[i] = 32;
        }
    }

    protected int isUnchangedByNormalization(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            return i - value.offset;
        }
        return -1;
    }

    protected boolean isInvalid(int value) {
        return XML11Char.isXML11Invalid(value);
    }

    protected boolean isInvalidLiteral(int value) {
        return !XML11Char.isXML11ValidLiteral(value);
    }

    protected boolean isValidNameChar(int value) {
        return XML11Char.isXML11Name(value);
    }

    protected boolean isValidNameStartChar(int value) {
        return XML11Char.isXML11NameStart(value);
    }

    protected boolean isValidNCName(int value) {
        return XML11Char.isXML11NCName(value);
    }

    protected boolean isValidNameStartHighSurrogate(int value) {
        return XML11Char.isXML11NameHighSurrogate(value);
    }

    protected boolean versionSupported(String version) {
        return version.equals("1.1") || version.equals("1.0");
    }

    protected String getVersionNotSupportedKey() {
        return "VersionNotSupported11";
    }
}

