/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.impl;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.impl.BpmnModelInstanceImpl;
import org.camunda.bpm.model.xml.ModelValidationException;
import org.camunda.bpm.model.xml.impl.ModelImpl;
import org.camunda.bpm.model.xml.impl.parser.AbstractModelParser;
import org.camunda.bpm.model.xml.impl.util.ReflectUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.xml.sax.SAXException;

public class BpmnParser
extends AbstractModelParser {
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public BpmnParser() {
        this.schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL bpmnSchema = ReflectUtil.getResource((String)"BPMN20.xsd", (ClassLoader)BpmnParser.class.getClassLoader());
        try {
            this.schema = this.schemaFactory.newSchema(bpmnSchema);
        }
        catch (SAXException e) {
            throw new ModelValidationException("Unable to parse schema:" + bpmnSchema);
        }
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        dbf.setAttribute(JAXP_SCHEMA_SOURCE, ReflectUtil.getResource((String)"BPMN20.xsd", (ClassLoader)BpmnParser.class.getClassLoader()).toString());
        super.configureFactory(dbf);
    }

    protected BpmnModelInstanceImpl createModelInstance(DomDocument document) {
        return new BpmnModelInstanceImpl((ModelImpl)Bpmn.INSTANCE.getBpmnModel(), Bpmn.INSTANCE.getBpmnModelBuilder(), document);
    }

    public BpmnModelInstanceImpl parseModelFromStream(InputStream inputStream) {
        return (BpmnModelInstanceImpl)super.parseModelFromStream(inputStream);
    }

    public BpmnModelInstanceImpl getEmptyModel() {
        return (BpmnModelInstanceImpl)super.getEmptyModel();
    }
}

