/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.commons.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.camunda.commons.utils.IoUtilLogger;
import org.camunda.commons.utils.UtilsLogger;

public class IoUtil {
    private static final IoUtilLogger LOG = UtilsLogger.IO_UTIL_LOGGER;
    public static final Charset ENCODING_CHARSET = Charset.forName("UTF-8");

    public static String inputStreamAsString(InputStream inputStream) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int read;
            byte[] buffer = new byte[16384];
            while ((read = inputStream.read(buffer)) > 0) {
                os.write(buffer, 0, read);
            }
            String string = os.toString("utf-8");
            return string;
        }
        catch (IOException e) {
            throw LOG.unableToReadInputStream(e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static InputStream stringAsInputStream(String string) {
        return new ByteArrayInputStream(string.getBytes(ENCODING_CHARSET));
    }

    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String fileAsString(String filename) {
        File classpathFile = IoUtil.getClasspathFile(filename);
        return IoUtil.fileAsString(classpathFile);
    }

    public static String fileAsString(File file) {
        try {
            return IoUtil.inputStreamAsString(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw LOG.fileNotFoundException(file.getAbsolutePath(), e);
        }
    }

    public static InputStream fileAsStream(String filename) {
        File classpathFile = IoUtil.getClasspathFile(filename);
        return IoUtil.fileAsStream(classpathFile);
    }

    public static InputStream fileAsStream(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw LOG.fileNotFoundException(file.getAbsolutePath(), e);
        }
    }

    public static File getClasspathFile(String filename) {
        if (filename == null) {
            throw LOG.nullParameter("filename");
        }
        return IoUtil.getClasspathFile(filename, null);
    }

    public static File getClasspathFile(String filename, ClassLoader classLoader) {
        if (filename == null) {
            throw LOG.nullParameter("filename");
        }
        URL fileUrl = null;
        if (classLoader != null) {
            fileUrl = classLoader.getResource(filename);
        }
        if (fileUrl == null && (fileUrl = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(filename)) == null) {
            classLoader = IoUtil.class.getClassLoader();
            fileUrl = classLoader.getResource(filename);
        }
        if (fileUrl == null) {
            throw LOG.fileNotFoundException(filename);
        }
        try {
            return new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw LOG.fileNotFoundException(filename, e);
        }
    }
}

