/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.protocol;

import connectjar.org.apache.http.HttpException;
import connectjar.org.apache.http.HttpResponse;
import connectjar.org.apache.http.HttpResponseInterceptor;
import connectjar.org.apache.http.annotation.Contract;
import connectjar.org.apache.http.annotation.ThreadingBehavior;
import connectjar.org.apache.http.protocol.HttpContext;
import connectjar.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

