/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.consulting.process_test_coverage;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.consulting.process_test_coverage.BpmnJsReport;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class ProcessTestCoverage {
    @Deprecated
    public static String bpmnDir = "../classes";
    public static String targetDir = "target/process-test-coverage";
    private static Map<String, Set<String>> processCoverage = new HashMap<String, Set<String>>();

    public static void calculate(ProcessInstance processInstance, ProcessEngine processEngine) {
        ProcessTestCoverage.calculate(processInstance.getId(), processEngine, ProcessTestCoverage.getCaller());
    }

    public static void calculate(String processInstanceId, ProcessEngine processEngine) {
        ProcessTestCoverage.calculate(processInstanceId, processEngine, ProcessTestCoverage.getCaller());
    }

    protected static void calculate(String processInstanceId, ProcessEngine processEngine, String caller) {
        try {
            HistoricProcessInstance processInstance = ProcessTestCoverage.getProcessInstance(processInstanceId, processEngine);
            String bpmnXml = ProcessTestCoverage.getBpmnXml(processInstance, processEngine);
            List<HistoricActivityInstance> activities = ProcessTestCoverage.getAuditTrail(processInstanceId, processEngine);
            String reportName = caller + ".html";
            BpmnJsReport.highlightActivities(bpmnXml, activities, reportName, targetDir);
            reportName = ProcessTestCoverage.getProcessDefinitionKey(processEngine, processInstance) + ".html";
            Set<String> coveredAcivityIds = ProcessTestCoverage.callculateProcessCoverage(ProcessTestCoverage.getProcessDefinitionKey(processEngine, processInstance), activities);
            BpmnJsReport.highlightActivities(bpmnXml, coveredAcivityIds, reportName, targetDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void calculate(ProcessEngine processEngine) {
        try {
            List processDefinitions = processEngine.getRepositoryService().createProcessDefinitionQuery().list();
            for (ProcessDefinition processDefinition : processDefinitions) {
                String bpmnXml = ProcessTestCoverage.getBpmnXml(processDefinition);
                List activities = processEngine.getHistoryService().createHistoricActivityInstanceQuery().processDefinitionId(processDefinition.getId()).list();
                Set<String> coveredAcivityIds = ProcessTestCoverage.callculateProcessCoverage(processDefinition.getKey(), activities);
                String reportName = processDefinition.getKey() + ".html";
                BpmnJsReport.highlightActivities(bpmnXml, coveredAcivityIds, reportName, targetDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Set<String> callculateProcessCoverage(String processDefinitionKey, List<HistoricActivityInstance> activities) {
        HashSet<String> coveredActivites;
        if (!processCoverage.containsKey(processDefinitionKey)) {
            coveredActivites = new HashSet();
            processCoverage.put(processDefinitionKey, coveredActivites);
        } else {
            coveredActivites = processCoverage.get(processDefinitionKey);
        }
        for (HistoricActivityInstance activity : activities) {
            coveredActivites.add(activity.getActivityId());
        }
        return coveredActivites;
    }

    protected static String getProcessDefinitionKey(ProcessEngine processEngine, HistoricProcessInstance processInstance) {
        return processEngine.getRepositoryService().getProcessDefinition(processInstance.getProcessDefinitionId()).getKey();
    }

    protected static String getBpmnXml(HistoricProcessInstance processInstance, ProcessEngine processEngine) throws IOException {
        String processDefinitionId = processInstance.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return ProcessTestCoverage.getBpmnXml(processDefinition);
    }

    protected static String getBpmnXml(ProcessDefinition processDefinition) throws IOException {
        InputStream inputStream = ProcessTestCoverage.class.getClassLoader().getResourceAsStream(processDefinition.getResourceName());
        return IOUtils.toString((InputStream)inputStream);
    }

    protected static HistoricProcessInstance getProcessInstance(String processInstanceId, ProcessEngine processEngine) {
        return (HistoricProcessInstance)processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected static List<HistoricActivityInstance> getAuditTrail(String processInstanceId, ProcessEngine processEngine) {
        List activities = processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        return activities;
    }

    protected static String getCaller() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[3];
        String callerMethod = caller.getClassName() + "." + caller.getMethodName();
        return callerMethod;
    }
}

