/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

public final class JsonSettings {
    private static final String MESSAGE_VALIDATION_STRICT_PROPERTY = "citrus.json.message.validation.strict";
    private static final String MESSAGE_VALIDATION_STRICT_ENV = "CITRUS_JSON_MESSAGE_VALIDATION_STRICT";
    private static final String MESSAGE_VALIDATION_STRICT_DEFAULT = "true";
    private static final String PERMISSIVE_MODE_PROPERTY = "citrus.json.permissive.mode";
    private static final String PERMISSIVE_MODE_ENV = "CITRUS_JSON_PERMISSIVE_MODE";
    private static final String PERMISSIVE_MODE_DEFAULT = String.valueOf(4032);

    private JsonSettings() {
    }

    public static int getPermissiveMoe() {
        String mode;
        return switch (mode = System.getProperty(PERMISSIVE_MODE_PROPERTY, System.getenv(PERMISSIVE_MODE_ENV) != null ? System.getenv(PERMISSIVE_MODE_ENV) : PERMISSIVE_MODE_DEFAULT)) {
            case "SIMPLE" -> 4032;
            case "RFC4627" -> 656;
            case "STRICTEST" -> 1168;
            case "PERMISSIVE" -> -1;
            default -> Integer.parseInt(mode);
        };
    }

    public static boolean isStrict() {
        return Boolean.parseBoolean(System.getProperty(MESSAGE_VALIDATION_STRICT_PROPERTY, System.getenv(MESSAGE_VALIDATION_STRICT_ENV) != null ? System.getenv(MESSAGE_VALIDATION_STRICT_ENV) : MESSAGE_VALIDATION_STRICT_DEFAULT));
    }
}

