/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.sql.Timestamp;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.ConflictException;
import org.cloudfoundry.identity.uaa.account.ForgotPasswordInfo;
import org.cloudfoundry.identity.uaa.account.NotFoundException;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.account.ResetPasswordService;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Controller
public class ResetPasswordController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResetPasswordService resetPasswordService;
    private final MessageService messageService;
    private final TemplateEngine templateEngine;
    private final UaaUrlUtils uaaUrlUtils;
    private final String brand;
    private final Pattern emailPattern;
    private final ExpiringCodeStore codeStore;

    public ResetPasswordController(ResetPasswordService resetPasswordService, MessageService messageService, TemplateEngine templateEngine, UaaUrlUtils uaaUrlUtils, String brand, ExpiringCodeStore codeStore) {
        this.resetPasswordService = resetPasswordService;
        this.messageService = messageService;
        this.templateEngine = templateEngine;
        this.uaaUrlUtils = uaaUrlUtils;
        this.brand = brand;
        this.emailPattern = Pattern.compile("^\\S+@\\S+\\.\\S+$");
        this.codeStore = codeStore;
    }

    @RequestMapping(value={"/forgot_password"}, method={RequestMethod.GET})
    public String forgotPasswordPage(Model model, @RequestParam(required=false, value="client_id") String clientId, @RequestParam(required=false, value="redirect_uri") String redirectUri) {
        model.addAttribute("client_id", (Object)clientId);
        model.addAttribute("redirect_uri", (Object)redirectUri);
        return "forgot_password";
    }

    @RequestMapping(value={"/forgot_password.do"}, method={RequestMethod.POST})
    public String forgotPassword(Model model, @RequestParam(value="email") String email, @RequestParam(value="client_id", defaultValue="") String clientId, @RequestParam(value="redirect_uri", defaultValue="") String redirectUri, HttpServletResponse response) {
        if (this.emailPattern.matcher(email).matches()) {
            this.forgotPassword(email, clientId, redirectUri);
            return "redirect:email_sent?code=reset_password";
        }
        return this.handleUnprocessableEntity(model, response, "message_code", "form_error");
    }

    private void forgotPassword(String email, String clientId, String redirectUri) {
        String subject = this.getSubjectText();
        String htmlContent = null;
        String userId = null;
        try {
            ForgotPasswordInfo forgotPasswordInfo = this.resetPasswordService.forgotPassword(email, clientId, redirectUri);
            userId = forgotPasswordInfo.getUserId();
            htmlContent = this.getCodeSentEmailHtml(forgotPasswordInfo.getResetPasswordCode().getCode(), email);
        }
        catch (ConflictException e) {
            htmlContent = this.getResetUnavailableEmailHtml(email);
            userId = e.getUserId();
        }
        catch (NotFoundException e) {
            this.logger.error((Object)("User with email address " + email + " not found."));
        }
        if (htmlContent != null && userId != null) {
            this.messageService.sendMessage(email, MessageType.PASSWORD_RESET, subject, htmlContent);
        }
    }

    private String getSubjectText() {
        String serviceName = this.getServiceName();
        if (StringUtils.isEmpty((Object)serviceName)) {
            return "Account password reset request";
        }
        return serviceName + " account password reset request";
    }

    private String getCodeSentEmailHtml(String code, String email) {
        String resetUrl = UaaUrlUtils.getUaaUrl("/reset_password");
        Context ctx = new Context();
        ctx.setVariable("serviceName", (Object)this.getServiceName());
        ctx.setVariable("code", (Object)code);
        ctx.setVariable("email", (Object)email);
        ctx.setVariable("resetUrl", (Object)resetUrl);
        return this.templateEngine.process("reset_password", (IContext)ctx);
    }

    private String getResetUnavailableEmailHtml(String email) {
        String hostname = this.uaaUrlUtils.getUaaHost();
        Context ctx = new Context();
        ctx.setVariable("serviceName", (Object)this.getServiceName());
        ctx.setVariable("email", (Object)email);
        ctx.setVariable("hostname", (Object)hostname);
        return this.templateEngine.process("reset_password_unavailable", (IContext)ctx);
    }

    private String getServiceName() {
        if (IdentityZoneHolder.get().equals((Object)IdentityZone.getUaa())) {
            return this.brand.equals("pivotal") ? "Pivotal" : "";
        }
        return IdentityZoneHolder.get().getName();
    }

    @RequestMapping(value={"/email_sent"}, method={RequestMethod.GET})
    public String emailSentPage(@ModelAttribute(value="code") String code) {
        return "email_sent";
    }

    @RequestMapping(value={"/reset_password"}, method={RequestMethod.GET}, params={"email", "code"})
    public String resetPasswordPage(Model model, HttpServletResponse response, @RequestParam(value="code") String code, @RequestParam(value="email") String email) {
        ExpiringCode expiringCode = this.codeStore.retrieveCode(code);
        if (expiringCode == null) {
            return this.handleUnprocessableEntity(model, response, "message_code", "bad_code");
        }
        Timestamp fiveMinutes = new Timestamp(System.currentTimeMillis() + 300000L);
        model.addAttribute("code", (Object)this.codeStore.generateCode(expiringCode.getData(), fiveMinutes, null).getCode());
        model.addAttribute("email", (Object)email);
        return "reset_password";
    }

    @RequestMapping(value={"/reset_password.do"}, method={RequestMethod.POST})
    public String resetPassword(Model model, @RequestParam(value="code") String code, @RequestParam(value="email") String email, @RequestParam(value="password") String password, @RequestParam(value="password_confirmation") String passwordConfirmation, HttpServletResponse response, HttpSession session) {
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(password, passwordConfirmation);
        if (!validation.valid()) {
            model.addAttribute("message_code", (Object)validation.getMessageCode());
            model.addAttribute("email", (Object)email);
            model.addAttribute("code", (Object)code);
            response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
            return "reset_password";
        }
        try {
            ResetPasswordService.ResetPasswordResponse resetPasswordResponse = this.resetPasswordService.resetPassword(code, password);
            ScimUser user = resetPasswordResponse.getUser();
            UaaPrincipal uaaPrincipal = new UaaPrincipal(user.getId(), user.getUserName(), user.getPrimaryEmail(), "uaa", null, IdentityZoneHolder.get().getId());
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)uaaPrincipal, null, UaaAuthority.USER_AUTHORITIES);
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            String redirectLocation = resetPasswordResponse.getRedirectUri();
            SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
            if (redirectLocation.equals("home") && savedRequest != null && savedRequest.getRedirectUrl() != null) {
                redirectLocation = savedRequest.getRedirectUrl();
            }
            return "redirect:" + redirectLocation;
        }
        catch (UaaException e) {
            return this.handleUnprocessableEntity(model, response, "message_code", "bad_code");
        }
        catch (InvalidPasswordException e) {
            return this.handleUnprocessableEntity(model, response, "message", e.getMessagesAsOneString());
        }
    }

    private String handleUnprocessableEntity(Model model, HttpServletResponse response, String attributeKey, String attributeValue) {
        model.addAttribute(attributeKey, (Object)attributeValue);
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return "forgot_password";
    }
}

