/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.AbstractClientParametersAuthenticationFilter;
import org.flywaydb.core.internal.util.StringUtils;
import org.springframework.security.core.AuthenticationException;

public class ClientParametersAuthenticationFilter
extends AbstractClientParametersAuthenticationFilter {
    @Override
    public void wrapClientCredentialLogin(HttpServletRequest req, HttpServletResponse res, Map<String, String> loginInfo, String clientId) throws IOException, ServletException {
        if (!StringUtils.hasText((String)req.getHeader("Authorization")) && this.isUrlEncodedForm(req)) {
            try {
                this.doClientCredentialLogin(req, loginInfo, clientId);
            }
            catch (AuthenticationException e) {
                this.logger.debug((Object)"Could not authenticate with client credentials.");
            }
        }
    }

    private boolean isUrlEncodedForm(HttpServletRequest req) {
        boolean isUrlEncodedForm = false;
        if (req.getHeader("Content-Type") != null) {
            isUrlEncodedForm = req.getHeader("Content-Type").startsWith("application/x-www-form-urlencoded");
        }
        return isUrlEncodedForm;
    }
}

