/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.StringUtils;

public class WhitelistLogoutHandler
extends SimpleUrlLogoutSuccessHandler {
    private static final Log logger = LogFactory.getLog(WhitelistLogoutHandler.class);
    private List<String> whitelist = null;
    private ClientDetailsService clientDetailsService;

    public WhitelistLogoutHandler(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public String getClientRedirect(HttpServletRequest request, String redirectUri) {
        String clientId = request.getParameter("client_id");
        logger.debug((Object)String.format("Evaluating client logout redirect client_id:%s and redirect:%s", clientId, redirectUri));
        if (!StringUtils.hasText((String)clientId) || !StringUtils.hasText((String)redirectUri)) {
            return null;
        }
        Set redirectUris = null;
        try {
            ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
            redirectUris = client.getRegisteredRedirectUri();
        }
        catch (NoSuchClientException x) {
            logger.debug((Object)String.format("Unable to find client with ID:%s for logout redirect", clientId));
        }
        return UaaUrlUtils.findMatchingRedirectUri(redirectUris, redirectUri);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String clientRedirectUri;
        String url = super.determineTargetUrl(request, response);
        String whiteListRedirect = UaaUrlUtils.findMatchingRedirectUri(this.getWhitelist(), url);
        boolean whitelisted = false;
        if (StringUtils.hasText((String)whiteListRedirect)) {
            url = whiteListRedirect;
            whitelisted = true;
        }
        if (StringUtils.hasText((String)(clientRedirectUri = this.getClientRedirect(request, url)))) {
            url = clientRedirectUri;
            whitelisted = true;
        }
        if (!whitelisted && this.getWhitelist() != null) {
            url = this.getDefaultTargetUrl();
        }
        logger.debug((Object)("Logout redirect[whitelisted:" + whitelisted + "; redirect:" + request.getParameter(this.getTargetUrlParameter()) + "] returning:" + url));
        return url;
    }
}

