/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.InvalidCodeException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class AutologinAuthenticationManager
implements AuthenticationManager {
    private Log logger = LogFactory.getLog(this.getClass());
    private ExpiringCodeStore codeStore;

    public void setExpiringCodeStore(ExpiringCodeStore expiringCodeStore) {
        this.codeStore = expiringCodeStore;
    }

    public ExpiringCode doRetrieveCode(String code) {
        return this.codeStore.retrieveCode(code);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof AuthzAuthenticationRequest)) {
            return null;
        }
        AuthzAuthenticationRequest request = (AuthzAuthenticationRequest)authentication;
        Map<String, String> info = request.getInfo();
        String code = info.get("code");
        ExpiringCode expiringCode = this.doRetrieveCode(code);
        Map codeData = null;
        try {
            if (expiringCode == null) {
                this.logger.debug((Object)"Autologin code has expired");
                throw new InvalidCodeException("expired_code", "Expired code", 422);
            }
            codeData = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
            if (codeData.get("action") == null || !((String)codeData.get("action")).equals(ExpiringCodeType.AUTOLOGIN.name())) {
                this.logger.debug((Object)"Code is not meant for autologin");
                throw new InvalidCodeException("invalid_code", "Not an autologin code", 422);
            }
        }
        catch (JsonUtils.JsonUtilException x) {
            throw new BadCredentialsException("JsonConversion error", (Throwable)x);
        }
        String username = (String)codeData.get("username");
        String origin = (String)codeData.get("origin");
        String userId = (String)codeData.get("user_id");
        String clientId = (String)codeData.get("client_id");
        if (clientId == null) {
            throw new BadCredentialsException("Cannot redeem provided code for user, client id missing");
        }
        UaaAuthenticationDetails details = (UaaAuthenticationDetails)authentication.getDetails();
        if (!clientId.equals(details.getClientId())) {
            throw new BadCredentialsException("Cannot redeem provided code for user, client mismatch");
        }
        UaaPrincipal principal = new UaaPrincipal(userId, username, null, origin, null, IdentityZoneHolder.get().getId());
        return new UaaAuthentication(principal, UaaAuthority.USER_AUTHORITIES, (UaaAuthenticationDetails)authentication.getDetails());
    }
}

