/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.StringUtils;

public class ClientAdminBootstrap
implements InitializingBean {
    private static Log logger = LogFactory.getLog(ClientAdminBootstrap.class);
    private Map<String, Map<String, Object>> clients = new HashMap<String, Map<String, Object>>();
    private Collection<String> autoApproveClients = Collections.emptySet();
    private ClientRegistrationService clientRegistrationService;
    private String domain = "cloudfoundry\\.com";
    private boolean defaultOverride = true;
    private final PasswordEncoder passwordEncoder;

    public ClientAdminBootstrap(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setDefaultOverride(boolean defaultOverride) {
        this.defaultOverride = defaultOverride;
    }

    public void setDomain(String domain) {
        this.domain = domain.replace(".", "\\.");
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setClients(Map<String, Map<String, Object>> clients) {
        this.clients = clients == null ? Collections.emptyMap() : new HashMap<String, Map<String, Object>>(clients);
    }

    public void setAutoApproveClients(Collection<String> autoApproveClients) {
        this.autoApproveClients = autoApproveClients;
    }

    public void setClientRegistrationService(ClientRegistrationService clientRegistrationService) {
        this.clientRegistrationService = clientRegistrationService;
    }

    public void afterPropertiesSet() throws Exception {
        this.addHttpsCallbacks();
        this.addNewClients();
        this.updateAutoApprovClients();
    }

    private void updateAutoApprovClients() {
        List clients = this.clientRegistrationService.listClientDetails();
        for (ClientDetails client : clients) {
            if (!this.autoApproveClients.contains(client.getClientId())) continue;
            BaseClientDetails base = new BaseClientDetails(client);
            HashMap<String, Boolean> info = new HashMap<String, Boolean>(client.getAdditionalInformation());
            info.put("autoapprove", true);
            base.setAdditionalInformation(info);
            logger.debug((Object)("Adding autoapprove flag: " + base));
            this.clientRegistrationService.updateClientDetails((ClientDetails)base);
        }
    }

    private void addHttpsCallbacks() {
        List clients = this.clientRegistrationService.listClientDetails();
        for (ClientDetails client : clients) {
            Set registeredRedirectUri = client.getRegisteredRedirectUri();
            if (registeredRedirectUri == null || registeredRedirectUri.isEmpty()) continue;
            HashSet<String> uris = new HashSet<String>(registeredRedirectUri);
            boolean newItems = false;
            for (String uri : registeredRedirectUri) {
                if (!uri.matches("^http://[^/]*\\." + this.domain + ".*")) continue;
                newItems = true;
                uris.remove(uri);
                uris.add("https" + uri.substring("http".length()));
            }
            if (!newItems) continue;
            BaseClientDetails newClient = new BaseClientDetails(client);
            newClient.setRegisteredRedirectUri(uris);
            logger.debug((Object)("Adding https callback: " + newClient));
            this.clientRegistrationService.updateClientDetails((ClientDetails)newClient);
        }
    }

    private String getRedirectUris(Map<String, Object> map) {
        HashSet<String> redirectUris = new HashSet<String>();
        if (map.get("redirect-uri") != null) {
            redirectUris.add((String)map.get("redirect-uri"));
        }
        if (map.get("signup_redirect_url") != null) {
            redirectUris.add((String)map.get("signup_redirect_url"));
        }
        if (map.get("change_email_redirect_url") != null) {
            redirectUris.add((String)map.get("change_email_redirect_url"));
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])redirectUris.toArray(new String[0]));
    }

    private void addNewClients() throws Exception {
        for (String clientId : this.clients.keySet()) {
            Map<String, Object> map = this.clients.get(clientId);
            BaseClientDetails client = new BaseClientDetails(clientId, (String)map.get("resource-ids"), (String)map.get("scope"), (String)map.get("authorized-grant-types"), (String)map.get("authorities"), this.getRedirectUris(map));
            client.setClientSecret((String)map.get("secret"));
            Integer validity = (Integer)map.get("access-token-validity");
            Boolean override = (Boolean)map.get("override");
            if (override == null) {
                override = this.defaultOverride;
            }
            HashMap<String, Object> info = new HashMap<String, Object>(map);
            if (validity != null) {
                client.setAccessTokenValiditySeconds(validity);
            }
            if ((validity = (Integer)map.get("refresh-token-validity")) != null) {
                client.setRefreshTokenValiditySeconds(validity);
            }
            client.setResourceIds(Collections.singleton("none"));
            if (client.getScope().isEmpty()) {
                client.setScope(Collections.singleton("uaa.none"));
            }
            if (client.getAuthorities().isEmpty()) {
                client.setAuthorities(Collections.singleton(UaaAuthority.UAA_NONE));
            }
            if (client.getAuthorizedGrantTypes().contains("authorization_code")) {
                client.getAuthorizedGrantTypes().add("refresh_token");
            }
            for (String key : Arrays.asList("resource-ids", "scope", "authorized-grant-types", "authorities", "redirect-uri", "secret", "id", "override", "access-token-validity", "refresh-token-validity")) {
                info.remove(key);
            }
            client.setAdditionalInformation(info);
            try {
                this.clientRegistrationService.addClientDetails((ClientDetails)client);
            }
            catch (ClientAlreadyExistsException e) {
                if (override == null || override.booleanValue()) {
                    logger.debug((Object)("Overriding client details for " + clientId));
                    this.clientRegistrationService.updateClientDetails((ClientDetails)client);
                    if (!StringUtils.hasText((String)client.getClientSecret()) || !this.didPasswordChange(clientId, client.getClientSecret())) continue;
                    this.clientRegistrationService.updateClientSecret(clientId, client.getClientSecret());
                    continue;
                }
                logger.debug((Object)e.getMessage());
            }
        }
    }

    protected boolean didPasswordChange(String clientId, String rawPassword) {
        if (this.getPasswordEncoder() != null && this.clientRegistrationService instanceof ClientDetailsService) {
            ClientDetails existing = ((ClientDetailsService)this.clientRegistrationService).loadClientByClientId(clientId);
            String existingPasswordHash = existing.getClientSecret();
            return !this.getPasswordEncoder().matches((CharSequence)rawPassword, existingPasswordHash);
        }
        return true;
    }
}

