/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.client.PreAuthenticatedPrincipalSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth.consumer.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ClientAuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private PreAuthenticatedPrincipalSource<?> principalSource;
    private boolean oauthAvailable = false;
    private boolean oauth2Available = false;

    public void setPreAuthenticatedPrincipalSource(PreAuthenticatedPrincipalSource<?> principalSource) {
        this.principalSource = principalSource;
    }

    public void afterPropertiesSet() {
        Assert.state((this.principalSource != null ? 1 : 0) != 0, (String)"User info source must be provided");
        super.afterPropertiesSet();
        try {
            this.oauth2Available = ClassUtils.isPresent((String)org.springframework.security.oauth2.client.http.AccessTokenRequiredException.class.getName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            this.oauthAvailable = ClassUtils.isPresent((String)AccessTokenRequiredException.class.getName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public ClientAuthenticationFilter(String defaultFilterProcessesUrl) {
        this.setAuthenticationManager(new DefaultFriendlyAuthenticationManager());
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        if (this.oauth2Available && failed instanceof SocialRedirectException) {
            throw ((SocialRedirectException)failed).getUserRedirectException();
        }
        if (this.oauthAvailable && failed instanceof AccessTokenRequiredException) {
            throw failed;
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        try {
            Object result = this.principalSource.getPrincipal();
            return result;
        }
        catch (UserRedirectRequiredException e) {
            throw new SocialRedirectException(e);
        }
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private static class SocialRedirectException
    extends AuthenticationException {
        public SocialRedirectException(UserRedirectRequiredException e) {
            super("Social user details extraction failed", (Throwable)e);
        }

        public UserRedirectRequiredException getUserRedirectException() {
            return (UserRedirectRequiredException)this.getCause();
        }
    }

    private static class DefaultFriendlyAuthenticationManager
    implements AuthenticationManager {
        private DefaultFriendlyAuthenticationManager() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            boolean authenticated = authentication.isAuthenticated();
            if (authentication instanceof PreAuthenticatedAuthenticationToken && !authenticated) {
                PreAuthenticatedAuthenticationToken preAuth = (PreAuthenticatedAuthenticationToken)authentication;
                if (preAuth.getPrincipal() instanceof Authentication) {
                    Authentication principal = (Authentication)preAuth.getPrincipal();
                    preAuth = new PreAuthenticatedAuthenticationToken((Object)principal, preAuth.getCredentials(), principal.getAuthorities());
                    authenticated = principal.isAuthenticated();
                }
                preAuth.setAuthenticated(authenticated);
                authentication = preAuth;
            }
            return authentication;
        }
    }
}

