/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UaaScopes {
    private List<String> scopes = Collections.unmodifiableList(Arrays.asList("zones.read", "zones.write", "zones.*.admin", "zones.*.read", "zones.*.clients.admin", "zones.*.clients.read", "zones.*.clients.write", "zones.*.scim.create", "zones.*.scim.read", "zones.*.scim.write", "zones.*.idps.read", "idps.read", "idps.write", "clients.admin", "clients.write", "clients.read", "clients.secret", "scim.write", "scim.read", "scim.create", "scim.userids", "scim.zones", "groups.update", "password.write", "oauth.login", "uaa.admin"));
    private Set<Pattern> regExPatterns = UaaStringUtils.constructWildcards(new HashSet<String>(this.scopes));

    public List<String> getUaaScopes() {
        return this.scopes;
    }

    public List<GrantedAuthority> getUaaAuthorities() {
        LinkedList<GrantedAuthority> result = new LinkedList<GrantedAuthority>();
        for (String s : this.getUaaScopes()) {
            result.add((GrantedAuthority)new SimpleGrantedAuthority(s));
        }
        return result;
    }

    public boolean isWildcardScope(String scope) {
        return UaaStringUtils.containsWildcard(scope);
    }

    public boolean isWildcardScope(GrantedAuthority authority) {
        return this.isWildcardScope(authority.getAuthority());
    }

    public boolean isUaaScope(String scope) {
        return UaaStringUtils.matches(this.regExPatterns, scope);
    }

    public boolean isUaaScope(GrantedAuthority authority) {
        return this.isUaaScope(authority.getAuthority());
    }
}

