/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.web.util.UriComponentsBuilder;

public class EmailService
implements MessageService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private JavaMailSender mailSender;
    private final String loginUrl;
    private final String brand;

    public EmailService(JavaMailSender mailSender, String loginUrl, String brand) {
        this.mailSender = mailSender;
        this.loginUrl = loginUrl;
        this.brand = brand;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    private Address[] getSenderAddresses() throws AddressException, UnsupportedEncodingException {
        String host = UriComponentsBuilder.fromHttpUrl((String)this.loginUrl).build().getHost();
        String name = null;
        name = IdentityZoneHolder.get().equals((Object)IdentityZone.getUaa()) ? (this.brand.equals("pivotal") ? "Pivotal" : "Cloud Foundry") : IdentityZoneHolder.get().getName();
        return new Address[]{new InternetAddress("admin@" + host, name)};
    }

    @Override
    public void sendMessage(String email, MessageType messageType, String subject, String htmlContent) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            message.addFrom(this.getSenderAddresses());
            message.addRecipients(Message.RecipientType.TO, email);
            message.setSubject(subject);
            message.setContent((Object)htmlContent, "text/html");
        }
        catch (MessagingException e) {
            this.logger.error((Object)("Exception raised while sending message to " + email), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Exception raised while sending message to " + email), (Throwable)e);
        }
        this.mailSender.send(message);
    }
}

