/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.authentication.Origin;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.WebRequest;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class AccessController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String SCOPE_PREFIX = "scope.";
    private ClientDetailsService clientDetailsService;
    private Boolean useSsl;
    private ApprovalStore approvalStore = null;

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    @RequestMapping(value={"/oauth/confirm_access"})
    public String confirm(Map<String, Object> model, final HttpServletRequest request, Principal principal, SessionStatus sessionStatus) throws Exception {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with before authorizing access.");
        }
        AuthorizationRequest clientAuthRequest = (AuthorizationRequest)model.remove("authorizationRequest");
        if (clientAuthRequest == null) {
            model.put("error", "No authorization request is present, so we cannot confirm access (we don't know what you are asking for).");
        } else {
            List scopes;
            String clientId = clientAuthRequest.getClientId();
            ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
            BaseClientDetails modifiableClient = new BaseClientDetails(client);
            modifiableClient.setClientSecret(null);
            model.put("auth_request", clientAuthRequest);
            model.put("client", modifiableClient);
            model.put("redirect_uri", this.getRedirectUri((ClientDetails)modifiableClient, clientAuthRequest));
            Map additionalInfo = client.getAdditionalInformation();
            String clientDisplayName = (String)additionalInfo.get("name");
            model.put("client_display_name", clientDisplayName != null ? clientDisplayName : clientId);
            Object autoApproved = additionalInfo.get("autoapprove");
            HashSet autoApprovedScopes = new HashSet();
            if (autoApproved instanceof Collection) {
                Collection scopes2 = (Collection)autoApproved;
                autoApprovedScopes.addAll(scopes2);
            } else if (autoApproved instanceof Boolean && ((Boolean)autoApproved).booleanValue() || "true".equals(autoApproved)) {
                autoApprovedScopes.addAll(modifiableClient.getScope());
            }
            ArrayList<Approval> filteredApprovals = new ArrayList<Approval>();
            List<Approval> approvals = this.approvalStore.getApprovals(Origin.getUserId((Authentication)principal), clientId);
            for (Approval approval : approvals) {
                if (autoApprovedScopes.contains(approval.getScope())) continue;
                filteredApprovals.add(approval);
            }
            ArrayList<String> approvedScopes = new ArrayList<String>();
            ArrayList<String> deniedScopes = new ArrayList<String>();
            block5: for (Approval approval : filteredApprovals) {
                switch (approval.getStatus()) {
                    case APPROVED: {
                        approvedScopes.add(approval.getScope());
                        continue block5;
                    }
                    case DENIED: {
                        deniedScopes.add(approval.getScope());
                        continue block5;
                    }
                }
                this.logger.error((Object)"Encountered an unknown scope. This is not supposed to happen");
            }
            ArrayList<String> undecidedScopes = new ArrayList<String>();
            for (String scope : clientAuthRequest.getScope()) {
                if (approvedScopes.contains(scope) || deniedScopes.contains(scope) || autoApprovedScopes.contains(scope)) continue;
                undecidedScopes.add(scope);
            }
            model.put("approved_scopes", this.getScopes((ClientDetails)modifiableClient, approvedScopes));
            model.put("denied_scopes", this.getScopes((ClientDetails)modifiableClient, deniedScopes));
            model.put("undecided_scopes", this.getScopes((ClientDetails)modifiableClient, undecidedScopes));
            ArrayList arrayList = new ArrayList();
            if (model.get("approved_scopes") != null) {
                scopes = (List)model.get("approved_scopes");
                arrayList.addAll(scopes);
            }
            if (model.get("denied_scopes") != null) {
                scopes = (List)model.get("denied_scopes");
                arrayList.addAll(scopes);
            }
            if (model.get("undecided_scopes") != null) {
                scopes = (List)model.get("undecided_scopes");
                arrayList.addAll(scopes);
            }
            model.put("scopes", arrayList);
            model.put("message", "To confirm or deny access POST to the following locations with the parameters requested.");
            HashMap<String, Object> options = new HashMap<String, Object>(){
                {
                    this.put("confirm", new HashMap<String, String>(){
                        {
                            this.put("location", AccessController.this.getLocation(request, "oauth/authorize"));
                            this.put("path", AccessController.this.getPath(request, "oauth/authorize"));
                            this.put("key", "user_oauth_approval");
                            this.put("value", "true");
                        }
                    });
                    this.put("deny", new HashMap<String, String>(){
                        {
                            this.put("location", AccessController.this.getLocation(request, "oauth/authorize"));
                            this.put("path", AccessController.this.getPath(request, "oauth/authorize"));
                            this.put("key", "user_oauth_approval");
                            this.put("value", "false");
                        }
                    });
                }
            };
            model.put("options", options);
        }
        return "access_confirmation";
    }

    private List<Map<String, String>> getScopes(ClientDetails client, ArrayList<String> scopes) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (String scope : scopes) {
            HashMap<String, String> map;
            if (!scope.contains(".")) {
                map = new HashMap<String, String>();
                map.put("code", SCOPE_PREFIX + scope);
                map.put("text", "Access your data with scope '" + scope + "'");
                result.add(map);
                continue;
            }
            map = new HashMap();
            String value = SCOPE_PREFIX + scope;
            String resource = scope.substring(0, scope.lastIndexOf("."));
            if ("uaa".equals(resource)) continue;
            String access = scope.substring(scope.lastIndexOf(".") + 1);
            map.put("code", value);
            map.put("text", "Access your '" + resource + "' resources with scope '" + access + "'");
            result.add(map);
        }
        Collections.sort(result, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String code1 = o1.get("code");
                String code2 = o2.get("code");
                if (code1.startsWith("scope.password") || code1.startsWith("scope.openid")) {
                    code1 = "aaa" + code1;
                }
                if (code2.startsWith("scope.password") || code2.startsWith("scope.openid")) {
                    code2 = "aaa" + code2;
                }
                return code1.compareTo(code2);
            }
        });
        return result;
    }

    private String getRedirectUri(ClientDetails client, AuthorizationRequest clientAuth) {
        String result = null;
        if (clientAuth.getRedirectUri() != null) {
            result = clientAuth.getRedirectUri();
        }
        if (client.getRegisteredRedirectUri() != null && !client.getRegisteredRedirectUri().isEmpty() && result == null) {
            result = (String)client.getRegisteredRedirectUri().iterator().next();
        }
        if (result != null) {
            if (result.contains("?")) {
                result = result.substring(0, result.indexOf("?"));
            }
            if (result.contains("#")) {
                result = result.substring(0, result.indexOf("#"));
            }
        }
        return result;
    }

    @RequestMapping(value={"/oauth/error"})
    public String handleError(WebRequest request, Map<String, Object> model) throws Exception {
        Object object = request.getAttribute("error", 0);
        if (object != null) {
            model.put("error", object);
        }
        return "access_confirmation_error";
    }

    protected String getLocation(HttpServletRequest request, String path) {
        return this.extractScheme(request) + "://" + request.getHeader("Host") + this.getPath(request, path);
    }

    private String getPath(HttpServletRequest request, String path) {
        String contextPath = request.getContextPath();
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.lastIndexOf("/") - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return contextPath + "/" + path;
    }

    protected String extractScheme(HttpServletRequest request) {
        return this.useSsl != null && this.useSsl != false ? "https" : request.getScheme();
    }
}

