/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.audit.event.TokenIssuedEvent;
import org.cloudfoundry.identity.uaa.authentication.Origin;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.SignerProvider;
import org.cloudfoundry.identity.uaa.oauth.TokenRevokedException;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeAccessToken;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.TokenPolicy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UaaTokenServices
implements AuthorizationServerTokenServices,
ResourceServerTokenServices,
InitializingBean,
ApplicationEventPublisherAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private UaaUserDatabase userDatabase = null;
    private ClientDetailsService clientDetailsService = null;
    private SignerProvider signerProvider = new SignerProvider();
    private String issuer = null;
    private String tokenEndpoint = null;
    private Set<String> defaultUserAuthorities = new HashSet<String>();
    private ApprovalStore approvalStore = null;
    private ApplicationEventPublisher applicationEventPublisher;
    private String host;
    private List<String> validIdTokenScopes = Arrays.asList("openid");
    private TokenPolicy tokenPolicy;
    private Set<String> excludedClaims = Collections.EMPTY_SET;

    public Set<String> getExcludedClaims() {
        return this.excludedClaims;
    }

    public void setExcludedClaims(Set<String> excludedClaims) {
        this.excludedClaims = excludedClaims;
    }

    public void setValidIdTokenScopes(List<String> validIdTokenScopes) {
        this.validIdTokenScopes = validIdTokenScopes;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue, TokenRequest request) throws AuthenticationException {
        String newRevocableHashSignature;
        if (null == refreshTokenValue) {
            throw new InvalidTokenException("Invalid refresh token (empty token)");
        }
        if (!"refresh_token".equals(request.getRequestParameters().get("grant_type"))) {
            throw new InvalidGrantException("Invalid grant type: " + (String)request.getRequestParameters().get("grant_type"));
        }
        Map<String, Object> claims = this.getClaimsForToken(refreshTokenValue);
        String clientId = (String)claims.get("cid");
        if (clientId == null || !clientId.equals(request.getClientId())) {
            throw new InvalidGrantException("Wrong client for this refresh token: " + refreshTokenValue);
        }
        String userid = (String)claims.get("user_id");
        UaaUser user = this.userDatabase.retrieveUserById(userid);
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        Integer refreshTokenIssuedAt = (Integer)claims.get("iat");
        long refreshTokenIssueDate = refreshTokenIssuedAt.longValue() * 1000L;
        Integer refreshTokenExpiry = (Integer)claims.get("exp");
        long refreshTokenExpireDate = refreshTokenExpiry.longValue() * 1000L;
        if (new Date(refreshTokenExpireDate).before(new Date())) {
            throw new InvalidTokenException("Invalid refresh token (expired): " + refreshTokenValue + " expired at " + new Date(refreshTokenExpireDate));
        }
        ArrayList tokenScopes = (ArrayList)claims.get("scope");
        HashSet<String> requestedScopes = request.getScope();
        if (requestedScopes.isEmpty()) {
            requestedScopes = new HashSet<String>(tokenScopes);
        }
        if (tokenScopes.isEmpty() || !tokenScopes.containsAll(requestedScopes)) {
            throw new InvalidScopeException("Unable to narrow the scope of the client authentication to " + requestedScopes + ".", new HashSet(tokenScopes));
        }
        String grantType = claims.get("grant_type").toString();
        this.checkForApproval(userid, clientId, requestedScopes, this.getAutoApprovedScopes(grantType, tokenScopes, client), new Date(refreshTokenIssueDate));
        Integer validity = client.getAccessTokenValiditySeconds();
        String nonce = (String)claims.get("nonce");
        Map additionalAuthorizationInfo = (Map)claims.get("az_attr");
        String revocableHashSignature = (String)claims.get("rev_sig");
        if (StringUtils.hasText((String)revocableHashSignature) && !revocableHashSignature.equals(newRevocableHashSignature = this.getRevocableTokenSignature(client, user))) {
            throw new TokenRevokedException(refreshTokenValue);
        }
        HashSet<String> audience = new HashSet<String>((ArrayList)claims.get("aud"));
        int zoneAccessTokenValidity = this.getZoneAccessTokenValidity();
        OAuth2AccessToken accessToken = this.createAccessToken(user.getId(), user, claims.get("auth_time") != null ? new Date((Long)claims.get("auth_time") * 1000L) : null, validity != null ? validity : zoneAccessTokenValidity, null, requestedScopes, clientId, audience, grantType, refreshTokenValue, nonce, additionalAuthorizationInfo, new HashSet<String>(), revocableHashSignature, false, null, null);
        return accessToken;
    }

    private int getZoneAccessTokenValidity() {
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityZoneConfiguration definition = zone.getConfig();
        int zoneAccessTokenValidity = this.tokenPolicy.getAccessTokenValidity();
        if (definition != null) {
            zoneAccessTokenValidity = definition.getTokenPolicy().getAccessTokenValidity() != -1 ? definition.getTokenPolicy().getAccessTokenValidity() : this.tokenPolicy.getAccessTokenValidity();
        }
        return zoneAccessTokenValidity;
    }

    private void checkForApproval(String userid, String clientId, Collection<String> requestedScopes, Collection<String> autoApprovedScopes, Date updateCutOff) {
        HashSet<String> approvedScopes = new HashSet<String>(autoApprovedScopes);
        List<Approval> approvals = this.approvalStore.getApprovals(userid, clientId);
        for (Approval approval : approvals) {
            if (!requestedScopes.contains(approval.getScope()) || approval.getStatus() != Approval.ApprovalStatus.APPROVED) continue;
            if (!approval.isCurrentlyActive()) {
                this.logger.debug((Object)("Approval " + approval + " has expired. Need to re-approve."));
                throw new InvalidTokenException("Invalid token (approvals expired)");
            }
            if (updateCutOff.before(approval.getLastUpdatedAt())) {
                this.logger.debug((Object)("At least one approval " + approval + " was updated more recently at " + approval.getLastUpdatedAt() + " access token was issued at " + updateCutOff));
                throw new InvalidTokenException("Invalid token (approvals updated): " + approval.getLastUpdatedAt());
            }
            approvedScopes.add(approval.getScope());
        }
        if (!approvedScopes.containsAll(requestedScopes)) {
            this.logger.debug((Object)("All requested scopes " + requestedScopes + " were not approved " + approvedScopes));
            HashSet<String> unapprovedScopes = new HashSet<String>(requestedScopes);
            unapprovedScopes.removeAll(approvedScopes);
            throw new InvalidTokenException("Invalid token (some requested scopes are not approved): " + unapprovedScopes);
        }
    }

    private OAuth2AccessToken createAccessToken(String userId, UaaUser user, Date userAuthenticationTime, int validitySeconds, Collection<GrantedAuthority> clientScopes, Set<String> requestedScopes, String clientId, Set<String> resourceIds, String grantType, String refreshToken, String nonce, Map<String, String> additionalAuthorizationAttributes, Set<String> responseTypes, String revocableHashSignature, boolean forceIdTokenCreation, Set<String> externalGroupsForIdToken, Map<String, List<String>> userAttributesForIdToken) throws AuthenticationException {
        String content;
        String tokenId = UUID.randomUUID().toString();
        CompositeAccessToken accessToken = new CompositeAccessToken(tokenId);
        if (validitySeconds > 0) {
            accessToken.setExpiration(new Date(System.currentTimeMillis() + (long)validitySeconds * 1000L));
        }
        accessToken.setRefreshToken((OAuth2RefreshToken)(refreshToken == null ? null : new DefaultOAuth2RefreshToken(refreshToken)));
        if (null == requestedScopes || requestedScopes.size() == 0) {
            this.logger.debug((Object)"No scopes were granted");
            throw new InvalidTokenException("No scopes were granted");
        }
        accessToken.setScope(requestedScopes);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("jti", accessToken.getValue());
        if (null != additionalAuthorizationAttributes) {
            info.put("az_attr", additionalAuthorizationAttributes);
        }
        if (nonce != null) {
            info.put("nonce", nonce);
        }
        accessToken.setAdditionalInformation(info);
        Map<String, ?> jwtAccessToken = this.createJWTAccessToken((OAuth2AccessToken)accessToken, userId, user, userAuthenticationTime, clientScopes, requestedScopes, clientId, resourceIds, grantType, refreshToken, revocableHashSignature);
        try {
            content = JsonUtils.writeValueAsString(jwtAccessToken);
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot convert access token to JSON", e);
        }
        String token = JwtHelper.encode((CharSequence)content, (Signer)this.signerProvider.getSigner()).getEncoded();
        accessToken.setValue(token);
        this.populateIdToken(accessToken, jwtAccessToken, requestedScopes, responseTypes, clientId, forceIdTokenCreation, externalGroupsForIdToken, user, userAttributesForIdToken);
        this.publish(new TokenIssuedEvent((OAuth2AccessToken)accessToken, SecurityContextHolder.getContext().getAuthentication()));
        return accessToken;
    }

    private void populateIdToken(CompositeAccessToken token, Map<String, ?> accessTokenValues, Set<String> scopes, Set<String> responseTypes, String aud, boolean forceIdTokenCreation, Set<String> externalGroupsForIdToken, UaaUser user, Map<String, List<String>> userAttributesForIdToken) {
        if (forceIdTokenCreation || scopes.contains("openid") && responseTypes.contains(CompositeAccessToken.ID_TOKEN)) {
            try {
                HashMap clone = new HashMap(accessTokenValues);
                clone.remove("authorities");
                HashSet<String> idTokenScopes = new HashSet<String>();
                for (String sc : scopes) {
                    if (this.validIdTokenScopes == null || !this.validIdTokenScopes.contains(sc)) continue;
                    idTokenScopes.add(sc);
                }
                clone.put("scope", idTokenScopes);
                clone.put("aud", new HashSet<String>(Arrays.asList(aud)));
                if (scopes.contains("roles") && externalGroupsForIdToken != null && !externalGroupsForIdToken.isEmpty()) {
                    clone.put("roles", externalGroupsForIdToken);
                }
                if (scopes.contains("user_attributes") && userAttributesForIdToken != null) {
                    clone.put("user_attributes", userAttributesForIdToken);
                }
                if (scopes.contains("profile") && user != null) {
                    String phoneNumber;
                    String familyName;
                    String givenName = user.getGivenName();
                    if (givenName != null) {
                        clone.put("given_name", givenName);
                    }
                    if ((familyName = user.getFamilyName()) != null) {
                        clone.put("family_name", familyName);
                    }
                    if ((phoneNumber = user.getPhoneNumber()) != null) {
                        clone.put("phone_number", phoneNumber);
                    }
                }
                String content = JsonUtils.writeValueAsString(clone);
                String encoded = JwtHelper.encode((CharSequence)content, (Signer)this.signerProvider.getSigner()).getEncoded();
                token.setIdTokenValue(encoded);
            }
            catch (JsonUtils.JsonUtilException e) {
                throw new IllegalStateException("Cannot convert ID token to JSON", e);
            }
        }
    }

    private Map<String, ?> createJWTAccessToken(OAuth2AccessToken token, String userId, UaaUser user, Date userAuthenticationTime, Collection<GrantedAuthority> clientScopes, Set<String> requestedScopes, String clientId, Set<String> resourceIds, String grantType, String refreshToken, String revocableHashSignature) {
        LinkedHashMap response = new LinkedHashMap();
        response.put("jti", token.getAdditionalInformation().get("jti"));
        response.putAll(token.getAdditionalInformation());
        response.put("sub", userId);
        if (null != clientScopes) {
            response.put("authorities", AuthorityUtils.authorityListToSet(clientScopes));
        }
        response.put("scope", requestedScopes);
        response.put("client_id", clientId);
        response.put("cid", clientId);
        response.put("azp", clientId);
        if (null != grantType) {
            response.put("grant_type", grantType);
        }
        if (!"client_credentials".equals(grantType)) {
            response.put("user_id", userId);
            if (user != null) {
                String username;
                String origin = user.getOrigin();
                if (StringUtils.hasLength((String)origin)) {
                    response.put("origin", origin);
                }
                response.put("user_name", (username = user.getUsername()) == null ? userId : username);
                String userEmail = user.getEmail();
                if (userEmail != null) {
                    response.put("email", userEmail);
                }
            }
            if (userAuthenticationTime != null) {
                response.put("auth_time", userAuthenticationTime.getTime() / 1000L);
            }
        }
        if (StringUtils.hasText((String)revocableHashSignature)) {
            response.put("rev_sig", revocableHashSignature);
        }
        response.put("iat", System.currentTimeMillis() / 1000L);
        if (token.getExpiration() != null) {
            response.put("exp", token.getExpiration().getTime() / 1000L);
        }
        if (this.getTokenEndpoint() != null) {
            response.put("iss", this.getTokenEndpoint());
            response.put("zid", IdentityZoneHolder.get().getId());
        }
        response.put("aud", resourceIds);
        for (String excludedClaim : this.getExcludedClaims()) {
            response.remove(excludedClaim);
        }
        return response;
    }

    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) throws AuthenticationException {
        String userId;
        ClientDetails client;
        Date userAuthenticationTime = null;
        UaaUser user = null;
        boolean wasIdTokenRequestedThroughAuthCodeScopeParameter = false;
        Collection clientScopes = null;
        if (authentication.isClientOnly()) {
            client = this.clientDetailsService.loadClientByClientId(authentication.getName());
            userId = client.getClientId();
            clientScopes = client.getAuthorities();
        } else {
            userId = this.getUserId(authentication);
            user = this.userDatabase.retrieveUserById(userId);
            if (authentication.getUserAuthentication() instanceof UaaAuthentication) {
                userAuthenticationTime = new Date(((UaaAuthentication)authentication.getUserAuthentication()).getAuthenticatedTime());
            }
        }
        client = this.clientDetailsService.loadClientByClientId(authentication.getOAuth2Request().getClientId());
        String revocableHashSignature = this.getRevocableTokenSignature(client, user);
        ExpiringOAuth2RefreshToken refreshToken = this.createRefreshToken(authentication, revocableHashSignature);
        String clientId = authentication.getOAuth2Request().getClientId();
        Set userScopes = authentication.getOAuth2Request().getScope();
        String grantType = (String)authentication.getOAuth2Request().getRequestParameters().get("grant_type");
        LinkedHashSet<String> modifiableUserScopes = new LinkedHashSet<String>();
        modifiableUserScopes.addAll(userScopes);
        String externalScopes = (String)authentication.getOAuth2Request().getRequestParameters().get("external_scopes");
        if (null != externalScopes && StringUtils.hasLength((String)externalScopes)) {
            modifiableUserScopes.addAll(OAuth2Utils.parseParameterList((String)externalScopes));
        }
        Set<String> externalGroupsForIdToken = Collections.EMPTY_SET;
        MultiValueMap<String, String> userAttributesForIdToken = Collections.EMPTY_MAP;
        if (authentication.getUserAuthentication() instanceof UaaAuthentication) {
            externalGroupsForIdToken = ((UaaAuthentication)authentication.getUserAuthentication()).getExternalGroups();
            userAttributesForIdToken = ((UaaAuthentication)authentication.getUserAuthentication()).getUserAttributes();
        }
        String nonce = (String)authentication.getOAuth2Request().getRequestParameters().get("nonce");
        Map<String, String> additionalAuthorizationAttributes = this.getAdditionalAuthorizationAttributes((String)authentication.getOAuth2Request().getRequestParameters().get("authorities"));
        if ("authorization_code".equals(authentication.getOAuth2Request().getRequestParameters().get("grant_type")) && "code".equals(authentication.getOAuth2Request().getRequestParameters().get("response_type")) && authentication.getOAuth2Request().getRequestParameters().get("scope") != null && ((String)authentication.getOAuth2Request().getRequestParameters().get("scope")).contains("openid")) {
            wasIdTokenRequestedThroughAuthCodeScopeParameter = true;
        }
        int zoneAccessTokenValidity = this.getZoneAccessTokenValidity();
        Integer validity = client.getAccessTokenValiditySeconds();
        Set<String> responseTypes = this.extractResponseTypes(authentication);
        OAuth2AccessToken accessToken = this.createAccessToken(userId, user, userAuthenticationTime, validity != null ? validity : zoneAccessTokenValidity, clientScopes, (Set<String>)modifiableUserScopes, clientId, authentication.getOAuth2Request().getResourceIds(), grantType, refreshToken != null ? refreshToken.getValue() : null, nonce, additionalAuthorizationAttributes, responseTypes, revocableHashSignature, wasIdTokenRequestedThroughAuthCodeScopeParameter, externalGroupsForIdToken, (Map<String, List<String>>)userAttributesForIdToken);
        return accessToken;
    }

    protected Set<String> extractResponseTypes(OAuth2Authentication authentication) {
        Set responseTypes = authentication.getOAuth2Request().getResponseTypes();
        if (responseTypes != null && responseTypes.size() == 1) {
            String storedResponseType = (String)responseTypes.iterator().next();
            String requesedResponseType = (String)authentication.getOAuth2Request().getRequestParameters().get("response_type");
            if ("code".equals(storedResponseType) && requesedResponseType != null) {
                responseTypes = OAuth2Utils.parseParameterList((String)requesedResponseType);
            }
        }
        return responseTypes;
    }

    private Map<String, String> getAdditionalAuthorizationAttributes(String authoritiesJson) {
        if (StringUtils.hasLength((String)authoritiesJson)) {
            try {
                Map authorities = (Map)JsonUtils.readValue((String)authoritiesJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Map additionalAuthorizationAttributes = (Map)authorities.get("az_attr");
                return additionalAuthorizationAttributes;
            }
            catch (Throwable t) {
                this.logger.error((Object)"Unable to read additionalAuthorizationAttributes", t);
            }
        }
        return null;
    }

    private ExpiringOAuth2RefreshToken createRefreshToken(OAuth2Authentication authentication, String revocableHashSignature) {
        String content;
        String grantType = (String)authentication.getOAuth2Request().getRequestParameters().get("grant_type");
        if (!this.isRefreshTokenSupported(grantType)) {
            return null;
        }
        Map<String, String> additionalAuthorizationAttributes = this.getAdditionalAuthorizationAttributes((String)authentication.getOAuth2Request().getRequestParameters().get("authorities"));
        int validitySeconds = this.getRefreshTokenValiditySeconds(authentication.getOAuth2Request());
        DefaultExpiringOAuth2RefreshToken token = new DefaultExpiringOAuth2RefreshToken(UUID.randomUUID().toString(), new Date(System.currentTimeMillis() + (long)validitySeconds * 1000L));
        String userId = this.getUserId(authentication);
        UaaUser user = this.userDatabase.retrieveUserById(userId);
        try {
            content = JsonUtils.writeValueAsString(this.createJWTRefreshToken((OAuth2RefreshToken)token, user, authentication.getOAuth2Request().getScope(), authentication.getOAuth2Request().getClientId(), grantType, additionalAuthorizationAttributes, authentication.getOAuth2Request().getResourceIds(), revocableHashSignature));
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot convert access token to JSON", e);
        }
        String jwtToken = JwtHelper.encode((CharSequence)content, (Signer)this.signerProvider.getSigner()).getEncoded();
        DefaultExpiringOAuth2RefreshToken refreshToken = new DefaultExpiringOAuth2RefreshToken(jwtToken, token.getExpiration());
        return refreshToken;
    }

    protected String getRevocableTokenSignature(ClientDetails client, UaaUser user) {
        String[] salts = new String[]{client.getClientId(), client.getClientSecret(), (String)client.getAdditionalInformation().get("token_salt"), user == null ? null : user.getId(), user == null ? null : user.getPassword(), user == null ? null : user.getSalt(), user == null ? null : user.getEmail(), user == null ? null : user.getUsername()};
        LinkedList<String> saltlist = new LinkedList<String>();
        for (String s : salts) {
            if (s == null) continue;
            saltlist.add(s);
        }
        return this.signerProvider.getRevocationHash(saltlist);
    }

    protected String getUserId(OAuth2Authentication authentication) {
        return Origin.getUserId(authentication.getUserAuthentication());
    }

    private Map<String, ?> createJWTRefreshToken(OAuth2RefreshToken token, UaaUser user, Set<String> scopes, String clientId, String grantType, Map<String, String> additionalAuthorizationAttributes, Set<String> resourceIds, String revocableSignature) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("jti", UUID.randomUUID().toString() + "-r");
        response.put("sub", user.getId());
        response.put("scope", scopes);
        if (null != additionalAuthorizationAttributes) {
            response.put("az_attr", additionalAuthorizationAttributes);
        }
        response.put("iat", System.currentTimeMillis() / 1000L);
        if (((ExpiringOAuth2RefreshToken)token).getExpiration() != null) {
            response.put("exp", ((ExpiringOAuth2RefreshToken)token).getExpiration().getTime() / 1000L);
        }
        response.put("cid", clientId);
        response.put("client_id", clientId);
        if (this.getTokenEndpoint() != null) {
            response.put("iss", this.getTokenEndpoint());
            response.put("zid", IdentityZoneHolder.get().getId());
        }
        if (null != grantType) {
            response.put("grant_type", grantType);
        }
        if (!"client_credentials".equals(grantType)) {
            response.put("user_name", user.getUsername());
            response.put("origin", user.getOrigin());
            response.put("user_id", user.getId());
        }
        if (StringUtils.hasText((String)revocableSignature)) {
            response.put("rev_sig", revocableSignature);
        }
        response.put("aud", resourceIds);
        return response;
    }

    protected boolean isRefreshTokenSupported(String grantType) {
        return "authorization_code".equals(grantType) || "password".equals(grantType) || "refresh_token".equals(grantType);
    }

    protected int getRefreshTokenValiditySeconds(OAuth2Request authorizationRequest) {
        ClientDetails client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId());
        Integer validity = client.getRefreshTokenValiditySeconds();
        if (validity != null) {
            return validity;
        }
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityZoneConfiguration definition = zone.getConfig();
        int zoneRefreshTokenValidity = this.tokenPolicy.getRefreshTokenValidity();
        if (definition != null) {
            zoneRefreshTokenValidity = definition.getTokenPolicy().getRefreshTokenValidity() != -1 ? definition.getTokenPolicy().getRefreshTokenValidity() : this.tokenPolicy.getRefreshTokenValidity();
        }
        return zoneRefreshTokenValidity;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clientDetailsService, (String)"clientDetailsService must be set");
        Assert.notNull((Object)this.issuer, (String)"issuer must be set");
        Assert.notNull((Object)this.approvalStore, (String)"approvalStore must be set");
        URI uri = new URI(this.issuer);
        this.host = uri.getHost();
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    private void validateClient(String clientId) throws AuthenticationException {
        if (clientId != null) {
            try {
                this.clientDetailsService.loadClientByClientId(clientId);
            }
            catch (NoSuchClientException x) {
                throw new OAuth2AccessDeniedException("Invalid client:" + clientId);
            }
            catch (ClientRegistrationException x) {
                throw new OAuth2AccessDeniedException("Invalid client:" + clientId);
            }
            catch (InvalidClientException x) {
                throw new OAuth2AccessDeniedException("Invalid client:" + clientId);
            }
        }
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException {
        Map<String, Object> claims = this.getClaimsForToken(accessToken);
        Integer expiration = (Integer)claims.get("exp");
        if (expiration != null && new Date((long)expiration.intValue() * 1000L).before(new Date())) {
            throw new InvalidTokenException("Invalid access token (expired): " + accessToken + " expired at " + new Date((long)expiration.intValue() * 1000L));
        }
        this.validateClient((String)claims.get("client_id"));
        this.validateClient((String)claims.get("cid"));
        ArrayList scopes = (ArrayList)claims.get("scope");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest((String)claims.get("client_id"), (Collection)scopes);
        ArrayList rids = (ArrayList)claims.get("aud");
        Set resourceIds = Collections.unmodifiableSet(rids == null ? new HashSet() : new HashSet(rids));
        authorizationRequest.setResourceIds(resourceIds);
        authorizationRequest.setApproved(true);
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString(this.defaultUserAuthorities));
        if (claims.containsKey("authorities")) {
            Object authoritiesFromClaims = claims.get("authorities");
            if (authoritiesFromClaims instanceof String) {
                authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)authoritiesFromClaims));
            }
            if (authoritiesFromClaims instanceof Collection) {
                authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString((Collection)((Collection)authoritiesFromClaims)));
            }
        }
        UaaAuthentication userAuthentication = null;
        if (claims.containsKey("email")) {
            UaaUser user = this.userDatabase.retrieveUserById((String)claims.get("user_id"));
            UaaPrincipal principal = new UaaPrincipal(user);
            userAuthentication = new UaaAuthentication(principal, UaaAuthority.USER_AUTHORITIES, null);
        } else {
            authorizationRequest.setAuthorities((Collection)authorities);
        }
        OAuth2Authentication authentication = new OAuth2Authentication(authorizationRequest.createOAuth2Request(), userAuthentication);
        authentication.setAuthenticated(true);
        return authentication;
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        ArrayList scopes;
        Map<String, Object> claims = this.getClaimsForToken(accessToken);
        CompositeAccessToken token = new CompositeAccessToken(accessToken);
        token.setTokenType("Bearer");
        Integer exp = (Integer)claims.get("exp");
        if (null != exp) {
            token.setExpiration(new Date(exp.longValue() * 1000L));
        }
        if (null != (scopes = (ArrayList)claims.get("scope")) && scopes.size() > 0) {
            token.setScope(new HashSet(scopes));
        }
        String clientId = (String)claims.get("cid");
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        String email = (String)claims.get("email");
        if (null != email) {
            UaaUser user;
            String userId = (String)claims.get("user_id");
            try {
                user = this.userDatabase.retrieveUserById(userId);
            }
            catch (UsernameNotFoundException e) {
                throw new InvalidTokenException("Invalid access token (user ID not found): " + userId);
            }
            Integer accessTokenIssuedAt = (Integer)claims.get("iat");
            long accessTokenIssueDate = accessTokenIssuedAt.longValue() * 1000L;
            this.validateUserScopes(scopes, user.getAuthorities());
            this.validateClientScopes(scopes, client.getScope());
            ArrayList tokenScopes = (ArrayList)claims.get("scope");
            Set<String> autoApprovedScopes = this.getAutoApprovedScopes(claims.get("grant_type"), tokenScopes, client);
            if (autoApprovedScopes.containsAll(tokenScopes)) {
                return token;
            }
            this.checkForApproval(userId, clientId, tokenScopes, autoApprovedScopes, new Date(accessTokenIssueDate));
        } else {
            this.validateClientAuthorities(scopes, (List)client.getAuthorities());
        }
        return token;
    }

    private void validateClientAuthorities(ArrayList<String> scopes, List<? extends GrantedAuthority> authorities) {
        this.validateAuthorities(scopes, authorities);
    }

    private void validateUserScopes(ArrayList<String> scopes, List<? extends GrantedAuthority> authorities) {
        this.validateAuthorities(scopes, authorities);
    }

    private void validateAuthorities(ArrayList<String> scopes, List<? extends GrantedAuthority> authorities) {
        if (authorities == null) {
            throw new InvalidTokenException("Invalid token (all scopes have been revoked)");
        }
        List authoritiesValue = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        scopes.stream().forEach(s -> {
            if (!authoritiesValue.contains(s)) {
                throw new InvalidTokenException("Invalid token (scope " + s + " has been revoked)");
            }
        });
    }

    private void validateClientScopes(ArrayList<String> scopes, Set<String> authorities) {
        if (authorities == null) {
            throw new InvalidTokenException("Invalid token (all scopes have been revoked)");
        }
        ArrayList<String> a = new ArrayList<String>();
        a.addAll(authorities);
        Set<Pattern> wildcards = UaaStringUtils.constructWildcards(authorities);
        scopes.stream().forEach(s -> {
            if (!authorities.contains(s) && !UaaStringUtils.matches(wildcards, s)) {
                throw new InvalidTokenException("Invalid token (scope " + s + " has been revoked)");
            }
        });
    }

    private Set<String> getAutoApprovedScopes(Object grantType, Collection<String> tokenScopes, ClientDetails client) {
        if (grantType != null && "password".equals(grantType.toString())) {
            return new HashSet<String>(tokenScopes);
        }
        Object autoApproved = client.getAdditionalInformation().get("autoapprove");
        HashSet<String> autoApprovedScopes = new HashSet<String>();
        if (autoApproved instanceof Collection) {
            Collection approvedScopes = (Collection)autoApproved;
            autoApprovedScopes.addAll(approvedScopes);
        } else if (autoApproved instanceof Boolean && ((Boolean)autoApproved).booleanValue() || "true".equals(autoApproved)) {
            autoApprovedScopes.addAll(client.getScope());
        }
        if (client instanceof BaseClientDetails && ((BaseClientDetails)client).getAutoApproveScopes() != null) {
            autoApprovedScopes.addAll(((BaseClientDetails)client).getAutoApproveScopes());
        }
        return UaaTokenUtils.instance().retainAutoApprovedScopes(tokenScopes, autoApprovedScopes);
    }

    private Map<String, Object> getClaimsForToken(String token) {
        Jwt tokenJwt = null;
        try {
            tokenJwt = JwtHelper.decodeAndVerify((String)token, (SignatureVerifier)this.signerProvider.getVerifier());
        }
        catch (Throwable t) {
            this.logger.debug((Object)"Invalid token (could not decode)", t);
            throw new InvalidTokenException("Invalid token (could not decode): " + token);
        }
        Map claims = null;
        try {
            claims = (Map)JsonUtils.readValue((String)tokenJwt.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot read token claims", e);
        }
        if (this.getTokenEndpoint() != null && !this.getTokenEndpoint().equals(claims.get("iss"))) {
            throw new InvalidTokenException("Invalid issuer for token:" + claims.get("iss"));
        }
        String signature = (String)claims.get("rev_sig");
        if (signature != null) {
            String clientId = (String)claims.get("cid");
            String userId = (String)claims.get("user_id");
            UaaUser user = null;
            ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
            try {
                user = this.userDatabase.retrieveUserById(userId);
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
                // empty catch block
            }
            if (signature != null && !signature.equals(this.getRevocableTokenSignature(client, user))) {
                throw new TokenRevokedException(token);
            }
        }
        return claims;
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        return null;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getTokenEndpoint() {
        if (this.issuer == null) {
            return null;
        }
        String hostToUse = this.host;
        if (StringUtils.hasText((String)IdentityZoneHolder.get().getSubdomain())) {
            hostToUse = IdentityZoneHolder.get().getSubdomain() + "." + this.host;
        }
        return UriComponentsBuilder.fromUriString((String)this.issuer).host(hostToUse).pathSegment(new String[]{"oauth/token"}).build().toUriString();
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setSignerProvider(SignerProvider signerProvider) {
        this.signerProvider = signerProvider;
    }

    public void setDefaultUserAuthorities(Set<String> defaultUserAuthorities) {
        this.defaultUserAuthorities = defaultUserAuthorities;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    private void publish(TokenIssuedEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy) {
        this.tokenPolicy = tokenPolicy;
    }

    public TokenPolicy getTokenPolicy() {
        return this.tokenPolicy;
    }
}

