/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.ConfigMetadataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.FixedHttpMetaDataProvider;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.StringUtils;

public class SamlIdentityProviderConfigurator
implements InitializingBean {
    private static Log logger = LogFactory.getLog(SamlIdentityProviderConfigurator.class);
    private String legacyIdpIdentityAlias;
    private volatile String legacyIdpMetaData;
    private String legacyNameId;
    private int legacyAssertionConsumerIndex;
    private boolean legacyMetadataTrustCheck = true;
    private boolean legacyShowSamlLink = true;
    private Map<SamlIdentityProviderDefinition, ExtendedMetadataDelegate> identityProviders = new HashMap<SamlIdentityProviderDefinition, ExtendedMetadataDelegate>();
    private List<SamlIdentityProviderDefinition> toBeFetchedProviders = new LinkedList<SamlIdentityProviderDefinition>();
    private HttpClientParams clientParams;
    private BasicParserPool parserPool;
    private Timer dummyTimer = new Timer(){

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public int purge() {
            return 0;
        }

        @Override
        public void schedule(TimerTask task, long delay) {
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date time) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        }
    };

    public SamlIdentityProviderConfigurator() {
        this.dummyTimer.cancel();
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions() {
        return Collections.unmodifiableList(new ArrayList<SamlIdentityProviderDefinition>(this.identityProviders.keySet()));
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitionsForZone(IdentityZone zone) {
        LinkedList<SamlIdentityProviderDefinition> result = new LinkedList<SamlIdentityProviderDefinition>();
        for (SamlIdentityProviderDefinition def : this.getIdentityProviderDefinitions()) {
            if (!zone.getId().equals(def.getZoneId())) continue;
            result.add(def);
        }
        return result;
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions(List<String> allowedIdps, IdentityZone zone) {
        List<SamlIdentityProviderDefinition> idpsInTheZone = this.getIdentityProviderDefinitionsForZone(zone);
        if (allowedIdps != null) {
            LinkedList<SamlIdentityProviderDefinition> result = new LinkedList<SamlIdentityProviderDefinition>();
            for (SamlIdentityProviderDefinition def : idpsInTheZone) {
                if (!allowedIdps.contains(def.getIdpEntityAlias())) continue;
                result.add(def);
            }
            return result;
        }
        return idpsInTheZone;
    }

    protected void parseIdentityProviderDefinitions() {
        this.identityProviders.clear();
        LinkedList<SamlIdentityProviderDefinition> providerDefinitions = new LinkedList<SamlIdentityProviderDefinition>(this.toBeFetchedProviders);
        if (this.getLegacyIdpMetaData() != null) {
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            def.setMetaDataLocation(this.getLegacyIdpMetaData());
            def.setMetadataTrustCheck(this.isLegacyMetadataTrustCheck());
            def.setNameID(this.getLegacyNameId());
            def.setAssertionConsumerIndex(this.getLegacyAssertionConsumerIndex());
            String alias = this.getLegacyIdpIdentityAlias();
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - Alias must be not null for deprecated IDP.");
            }
            def.setIdpEntityAlias(alias);
            def.setShowSamlLink(this.isLegacyShowSamlLink());
            def.setLinkText("Use your corporate credentials");
            def.setZoneId(IdentityZone.getUaa().getId());
            providerDefinitions.add(def);
        }
        HashSet<String> uniqueAlias = new HashSet<String>();
        for (SamlIdentityProviderDefinition def : providerDefinitions) {
            String alias = this.getUniqueAlias(def);
            if (uniqueAlias.contains(alias)) {
                throw new IllegalStateException("Duplicate IDP alias found:" + alias);
            }
            uniqueAlias.add(alias);
        }
        for (SamlIdentityProviderDefinition def : providerDefinitions) {
            try {
                this.addSamlIdentityProviderDefinition(def);
            }
            catch (MetadataProviderException e) {
                logger.error((Object)("Unable to configure SAML provider:" + def), (Throwable)e);
            }
        }
    }

    protected String getUniqueAlias(SamlIdentityProviderDefinition def) {
        return def.getUniqueAlias();
    }

    public synchronized ExtendedMetadataDelegate[] addSamlIdentityProviderDefinition(SamlIdentityProviderDefinition providerDefinition) throws MetadataProviderException {
        ExtendedMetadataDelegate deleted = null;
        if (providerDefinition == null) {
            throw new NullPointerException();
        }
        if (!StringUtils.hasText((String)providerDefinition.getIdpEntityAlias())) {
            throw new NullPointerException("SAML IDP Alias must be set");
        }
        if (!StringUtils.hasText((String)providerDefinition.getZoneId())) {
            throw new NullPointerException("IDP Zone Id must be set");
        }
        for (SamlIdentityProviderDefinition def : this.getIdentityProviderDefinitions()) {
            if (!this.getUniqueAlias(providerDefinition).equals(this.getUniqueAlias(def))) continue;
            deleted = this.identityProviders.remove(def);
            break;
        }
        SamlIdentityProviderDefinition clone = providerDefinition.clone();
        ExtendedMetadataDelegate added = this.getExtendedMetadataDelegate(clone);
        String entityIDToBeAdded = ((ConfigMetadataProvider)added.getDelegate()).getEntityID();
        boolean entityIDexists = false;
        for (Map.Entry<SamlIdentityProviderDefinition, ExtendedMetadataDelegate> entry : this.identityProviders.entrySet()) {
            ConfigMetadataProvider provider;
            SamlIdentityProviderDefinition definition = entry.getKey();
            if (!clone.getZoneId().equals(definition.getZoneId()) || !entityIDToBeAdded.equals((provider = (ConfigMetadataProvider)entry.getValue().getDelegate()).getEntityID())) continue;
            entityIDexists = true;
            break;
        }
        if (entityIDexists) {
            throw new MetadataProviderException("Duplicate entity ID:" + entityIDToBeAdded);
        }
        this.identityProviders.put(clone, added);
        return new ExtendedMetadataDelegate[]{added, deleted};
    }

    public synchronized ExtendedMetadataDelegate removeIdentityProviderDefinition(SamlIdentityProviderDefinition providerDefinition) {
        return this.identityProviders.remove(providerDefinition);
    }

    public List<ExtendedMetadataDelegate> getSamlIdentityProviders() {
        return this.getSamlIdentityProviders(null);
    }

    public List<ExtendedMetadataDelegate> getSamlIdentityProviders(IdentityZone zone) {
        LinkedList<ExtendedMetadataDelegate> result = new LinkedList<ExtendedMetadataDelegate>();
        for (SamlIdentityProviderDefinition def : this.getIdentityProviderDefinitions()) {
            ExtendedMetadataDelegate metadata;
            if (zone != null && !zone.getId().equals(def.getZoneId()) || (metadata = this.identityProviders.get(def)) == null) continue;
            result.add(metadata);
        }
        return result;
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegateFromCache(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        return this.identityProviders.get(def);
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegate(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        ExtendedMetadataDelegate metadata;
        switch (def.getType()) {
            case DATA: {
                metadata = this.configureXMLMetadata(def);
                break;
            }
            case URL: {
                metadata = this.configureURLMetadata(def);
                break;
            }
            default: {
                throw new MetadataProviderException("Invalid metadata type for alias[" + def.getIdpEntityAlias() + "]:" + def.getMetaDataLocation());
            }
        }
        return metadata;
    }

    protected ExtendedMetadataDelegate configureXMLMetadata(SamlIdentityProviderDefinition def) {
        ConfigMetadataProvider configMetadataProvider = new ConfigMetadataProvider(def.getZoneId(), def.getIdpEntityAlias(), def.getMetaDataLocation());
        configMetadataProvider.setParserPool((ParserPool)this.getParserPool());
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setLocal(false);
        extendedMetadata.setAlias(def.getIdpEntityAlias());
        ExtendedMetadataDelegate delegate = new ExtendedMetadataDelegate((MetadataProvider)configMetadataProvider, extendedMetadata);
        delegate.setMetadataTrustCheck(def.isMetadataTrustCheck());
        return delegate;
    }

    protected ExtendedMetadataDelegate configureURLMetadata(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        Class<?> socketFactory = null;
        try {
            def = def.clone();
            socketFactory = Class.forName(def.getSocketFactoryClassName());
            ExtendedMetadata extendedMetadata = new ExtendedMetadata();
            extendedMetadata.setAlias(def.getIdpEntityAlias());
            SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager(true);
            connectionManager.getParams().setDefaults((HttpParams)this.getClientParams());
            HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
            FixedHttpMetaDataProvider fixedHttpMetaDataProvider = new FixedHttpMetaDataProvider(this.dummyTimer, client, this.adjustURIForPort(def.getMetaDataLocation()));
            fixedHttpMetaDataProvider.setSocketFactory((ProtocolSocketFactory)socketFactory.newInstance());
            byte[] metadata = fixedHttpMetaDataProvider.fetchMetadata();
            def.setMetaDataLocation(new String(metadata, StandardCharsets.UTF_8));
            return this.configureXMLMetadata(def);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Invalid socket factory(invalid URI):" + def.getMetaDataLocation(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
    }

    protected String adjustURIForPort(String uri) throws URISyntaxException {
        URI metadataURI = new URI(uri);
        if (metadataURI.getPort() < 0) {
            switch (metadataURI.getScheme()) {
                case "https": {
                    return new URIBuilder(uri).setPort(443).build().toString();
                }
                case "http": {
                    return new URIBuilder(uri).setPort(80).build().toString();
                }
            }
            return uri;
        }
        return uri;
    }

    public void setIdentityProviders(Map<String, Map<String, Object>> providers) {
        this.identityProviders.clear();
        if (providers == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : providers.entrySet()) {
            String alias = entry.getKey();
            Map<String, Object> saml = entry.getValue();
            String metaDataLocation = (String)saml.get("idpMetadata");
            String nameID = (String)saml.get("nameID");
            Integer assertionIndex = (Integer)saml.get("assertionConsumerIndex");
            Boolean trustCheck = (Boolean)saml.get("metadataTrustCheck");
            Boolean showLink = (Boolean)entry.getValue().get("showSamlLoginLink");
            String socketFactoryClassName = (String)saml.get("socketFactoryClassName");
            String linkText = (String)entry.getValue().get("linkText");
            String iconUrl = (String)entry.getValue().get("iconUrl");
            String zoneId = (String)entry.getValue().get("zoneId");
            Boolean addShadowUserOnLogin = (Boolean)entry.getValue().get("addShadowUserOnLogin");
            List emailDomain = (List)saml.get("emailDomain");
            List externalGroupsWhitelist = (List)saml.get("externalGroupsWhitelist");
            Map attributeMappings = (Map)saml.get("attributeMappings");
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - alias must not be null [" + metaDataLocation + "]");
            }
            if (metaDataLocation == null) {
                throw new IllegalArgumentException("Invalid IDP - metaDataLocation must not be null [" + alias + "]");
            }
            def.setIdpEntityAlias(alias);
            def.setAssertionConsumerIndex(assertionIndex == null ? 0 : assertionIndex);
            def.setMetaDataLocation(metaDataLocation);
            def.setNameID(nameID);
            def.setMetadataTrustCheck(trustCheck == null ? true : trustCheck);
            def.setShowSamlLink(showLink == null ? true : showLink);
            def.setSocketFactoryClassName(socketFactoryClassName);
            def.setLinkText(linkText);
            def.setIconUrl(iconUrl);
            def.setEmailDomain(emailDomain);
            def.setExternalGroupsWhitelist(externalGroupsWhitelist);
            def.setAttributeMappings(attributeMappings);
            def.setZoneId(StringUtils.hasText((String)zoneId) ? zoneId : IdentityZone.getUaa().getId());
            def.setAddShadowUserOnLogin(addShadowUserOnLogin == null ? true : addShadowUserOnLogin);
            this.toBeFetchedProviders.add(def);
        }
    }

    public String getLegacyIdpIdentityAlias() {
        return this.legacyIdpIdentityAlias;
    }

    public void setLegacyIdpIdentityAlias(String legacyIdpIdentityAlias) {
        this.legacyIdpIdentityAlias = "null".equals(legacyIdpIdentityAlias) ? null : legacyIdpIdentityAlias;
    }

    public String getLegacyIdpMetaData() {
        return this.legacyIdpMetaData;
    }

    public void setLegacyIdpMetaData(String legacyIdpMetaData) {
        this.legacyIdpMetaData = "null".equals(legacyIdpMetaData) ? null : legacyIdpMetaData;
    }

    public String getLegacyNameId() {
        return this.legacyNameId;
    }

    public void setLegacyNameId(String legacyNameId) {
        this.legacyNameId = legacyNameId;
    }

    public int getLegacyAssertionConsumerIndex() {
        return this.legacyAssertionConsumerIndex;
    }

    public void setLegacyAssertionConsumerIndex(int legacyAssertionConsumerIndex) {
        this.legacyAssertionConsumerIndex = legacyAssertionConsumerIndex;
    }

    public boolean isLegacyMetadataTrustCheck() {
        return this.legacyMetadataTrustCheck;
    }

    public void setLegacyMetadataTrustCheck(boolean legacyMetadataTrustCheck) {
        this.legacyMetadataTrustCheck = legacyMetadataTrustCheck;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public BasicParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(BasicParserPool parserPool) {
        this.parserPool = parserPool;
    }

    public boolean isLegacyShowSamlLink() {
        return this.legacyShowSamlLink;
    }

    public void setLegacyShowSamlLink(boolean legacyShowSamlLink) {
        this.legacyShowSamlLink = legacyShowSamlLink;
    }

    public void afterPropertiesSet() throws Exception {
        this.parseIdentityProviderDefinitions();
    }
}

