/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources.jdbc;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.cloudfoundry.identity.uaa.resources.jdbc.LimitSqlAdapter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class JdbcPagingList<E>
extends AbstractList<E> {
    private final int size;
    private int start = 0;
    private List<E> current;
    private final int pageSize;
    private final RowMapper<E> mapper;
    private final Map<String, ?> args;
    private final String sql;
    private final NamedParameterJdbcTemplate parameterJdbcTemplate;
    private final LimitSqlAdapter limitSqlAdapter;

    public JdbcPagingList(JdbcTemplate jdbTemplate, LimitSqlAdapter limitSqlAdapter, String sql, RowMapper<E> mapper, int pageSize) {
        this(jdbTemplate, limitSqlAdapter, sql, Collections.emptyMap(), mapper, pageSize);
    }

    public JdbcPagingList(JdbcTemplate jdbcTemplate, LimitSqlAdapter limitSqlAdapter, String sql, Map<String, ?> args, RowMapper<E> mapper, int pageSize) {
        this(new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate), limitSqlAdapter, sql, args, mapper, pageSize);
    }

    public JdbcPagingList(NamedParameterJdbcTemplate jdbcTemplate, LimitSqlAdapter limitSqlAdapter, String sql, Map<String, ?> args, RowMapper<E> mapper, int pageSize) {
        this.parameterJdbcTemplate = jdbcTemplate;
        this.sql = sql;
        this.args = args;
        this.mapper = mapper;
        this.size = (Integer)this.parameterJdbcTemplate.queryForObject(this.getCountSql(sql), args, Integer.class);
        this.pageSize = pageSize;
        this.limitSqlAdapter = limitSqlAdapter;
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.current == null || index - this.start >= this.pageSize || index < this.start) {
            this.current = this.parameterJdbcTemplate.query(this.limitSqlAdapter.getLimitSql(this.sql, index, this.pageSize), this.args, this.mapper);
            this.start = index;
        }
        return this.current.get(index - this.start);
    }

    @Override
    public Iterator<E> iterator() {
        return new SafeIterator(super.iterator());
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("The indexes provided are outside the bounds of this list.");
        }
        return new SafeIteratorList(super.subList(fromIndex, toIndex));
    }

    private String getCountSql(String sql) {
        String result = sql.toLowerCase().replaceAll("select (.*?) from (.*)", "select count(*) from $2");
        if (result.contains("order by")) {
            result = result.substring(0, result.lastIndexOf("order by"));
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static class SafeIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private boolean polled = false;
        private boolean hasNext = false;
        private T next;

        public SafeIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.polled) {
                this.polled = true;
                try {
                    this.next = this.iterator.next();
                    this.hasNext = true;
                    return true;
                }
                catch (NoSuchElementException e) {
                    this.hasNext = false;
                    return false;
                }
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.polled = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: readonly interator");
        }
    }

    private static class SafeIteratorList<T>
    extends AbstractList<T> {
        private final List<T> list;

        public SafeIteratorList(List<T> list) {
            this.list = list;
        }

        @Override
        public Iterator<T> iterator() {
            return new SafeIterator(super.iterator());
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

