/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class DisableInternalUserManagementFilter
extends OncePerRequestFilter {
    public static final String DISABLE_INTERNAL_USER_MANAGEMENT = "disableInternalUserManagement";
    private final IdentityProviderProvisioning identityProviderProvisioning;
    private static String regex = "^/login";
    private Pattern pattern = Pattern.compile(regex);

    public DisableInternalUserManagementFilter(IdentityProviderProvisioning identityProviderProvisioning) {
        this.identityProviderProvisioning = identityProviderProvisioning;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.matches(request)) {
            IdentityProvider idp = this.identityProviderProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
            boolean isDisableInternalUserManagement = false;
            UaaIdentityProviderDefinition config = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)idp.getConfig(), UaaIdentityProviderDefinition.class);
            if (config != null) {
                isDisableInternalUserManagement = config.isDisableInternalUserManagement();
            }
            request.setAttribute(DISABLE_INTERNAL_USER_MANAGEMENT, (Object)isDisableInternalUserManagement);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean matches(HttpServletRequest request) {
        if (request.getContextPath() != null && request.getContextPath().length() > 0) {
            return this.pattern.matcher(request.getServletPath()).matches();
        }
        return this.pattern.matcher(request.getRequestURI()).matches();
    }
}

