/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class LineAwareLayout
extends Layout {
    private Layout messageLayout;
    private Layout lineLayout;

    public LineAwareLayout() {
    }

    public LineAwareLayout(Layout lineLayout) {
        this(lineLayout, null);
    }

    public LineAwareLayout(Layout lineLayout, Layout messageLayout) {
        this.messageLayout = messageLayout;
        this.lineLayout = lineLayout;
    }

    public String format(LoggingEvent event) {
        String[] throwable;
        if (this.lineLayout == null) {
            return this.messageLayout == null ? event.getRenderedMessage() : this.messageLayout.format(event);
        }
        String message = event.getRenderedMessage();
        String[] lines = this.messageLayout == null && (throwable = event.getThrowableStrRep()) != null ? throwable : message.split("\r?\n");
        StringBuffer strBuf = new StringBuffer();
        for (String line : lines) {
            String formattedLine = this.lineLayout.format(LineAwareLayout.replaceEventMessageWithoutThrowable(event, line));
            strBuf.append(formattedLine);
        }
        String formattedLines = strBuf.toString();
        if (this.messageLayout == null) {
            return formattedLines;
        }
        return this.messageLayout.format(LineAwareLayout.replaceEventMessage(event, formattedLines));
    }

    public boolean ignoresThrowable() {
        return this.messageLayout != null && this.messageLayout.ignoresThrowable();
    }

    public void activateOptions() {
        if (this.lineLayout != null) {
            this.lineLayout.activateOptions();
        }
        if (this.messageLayout != null) {
            this.messageLayout.activateOptions();
        }
    }

    public Layout getLineLayout() {
        return this.lineLayout;
    }

    public void setLineLayout(Layout lineLayout) {
        this.lineLayout = lineLayout;
    }

    public Layout getMessageLayout() {
        return this.messageLayout;
    }

    public void setMessageLayout(Layout messageLayout) {
        this.messageLayout = messageLayout;
    }

    private static LoggingEvent replaceEventMessageWithoutThrowable(LoggingEvent event, String message) {
        return new LoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), (Object)message, event.getThreadName(), null, event.getNDC(), event.getLocationInformation(), event.getProperties());
    }

    private static LoggingEvent replaceEventMessage(LoggingEvent event, String message) {
        return new LoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), (Object)message, event.getThreadName(), event.getThrowableInformation(), event.getNDC(), event.getLocationInformation(), event.getProperties());
    }
}

