/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public class UaaStringUtils {
    public static String camelToUnderscore(String value) {
        String result = value.replace(" ", "_");
        result = result.replaceAll("([a-z])([A-Z])", "$1_$2");
        result = result.replace(".", "_");
        result = result.toLowerCase();
        return result;
    }

    public static String getErrorName(Exception e) {
        String name = e.getClass().getSimpleName();
        if ((name = UaaStringUtils.camelToUnderscore(name)).endsWith("_exception")) {
            name = name.substring(0, name.lastIndexOf("_exception"));
        }
        return name;
    }

    public static Map<String, ?> hidePasswords(Map<String, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.putAll(map);
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof String) {
                if (!UaaStringUtils.isPassword(key)) continue;
                result.put(key, "#");
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map bare = (Map)value;
            result.put(key, UaaStringUtils.hidePasswords(bare));
        }
        return result;
    }

    public static Properties hidePasswords(Properties properties) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties);
        for (String key : properties.stringPropertyNames()) {
            if (!UaaStringUtils.isPassword(key)) continue;
            result.put(key, "#");
        }
        return result;
    }

    public static boolean containsWildcard(String s) {
        if (StringUtils.hasText((String)s)) {
            return !UaaStringUtils.escapeRegExCharacters(s).equals(UaaStringUtils.constructSimpleWildcardPattern(s));
        }
        return false;
    }

    public static String escapeRegExCharacters(String s) {
        return UaaStringUtils.escapeRegExCharacters(s, "([^a-zA-z0-9 ])");
    }

    public static String escapeRegExCharacters(String s, String pattern) {
        return s.replaceAll(pattern, "\\\\$1");
    }

    public static String constructSimpleWildcardPattern(String s) {
        String result = UaaStringUtils.escapeRegExCharacters(s);
        return result.replace("\\*", "[^\\\\.]+");
    }

    public static Set<Pattern> constructWildcards(Collection<String> wildcardStrings) {
        HashSet<Pattern> wildcards = new HashSet<Pattern>();
        for (String wildcard : wildcardStrings) {
            String pattern = UaaStringUtils.constructSimpleWildcardPattern(wildcard);
            wildcards.add(Pattern.compile(pattern));
        }
        return wildcards;
    }

    public static boolean matches(Set<Pattern> wildcards, String scope) {
        for (Pattern wildcard : wildcards) {
            if (!wildcard.matcher(scope).matches()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, ?> getMapFromProperties(Properties properties, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            result.put(name, properties.getProperty(key));
        }
        return result;
    }

    public static String getHostIfArgIsURL(String arg) {
        try {
            URL uri = new URL(arg);
            return uri.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return arg;
        }
    }

    private static boolean isPassword(String key) {
        return key.endsWith("password") || key.endsWith("secret") || key.endsWith("signing-key");
    }

    public static Set<String> getStringsFromAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            result.add(grantedAuthority.getAuthority());
        }
        return result;
    }

    public static List<? extends GrantedAuthority> getAuthoritiesFromStrings(Collection<String> authorities) {
        if (authorities == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SimpleGrantedAuthority> result = new LinkedList<SimpleGrantedAuthority>();
        for (String s : authorities) {
            result.add(new SimpleGrantedAuthority(s));
        }
        return result;
    }

    public static boolean containsIgnoreCase(List<String> list, String findMe) {
        for (String s : list) {
            if (!findMe.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

