/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.ZoneDoesNotExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class IdentityZoneSwitchingFilter
extends OncePerRequestFilter {
    private final IdentityZoneProvisioning dao;
    public static final String HEADER = "X-Identity-Zone-Id";
    public static final String SUBDOMAIN_HEADER = "X-Identity-Zone-Subdomain";
    public static final String ZONE_ID_MATCH = "{zone_id}";
    public static final String ZONES_ZONE_ID_PREFIX = "zones.";
    public static final String ZONES_ZONE_ID_ADMIN = "zones.{zone_id}.admin";
    public static final List<String> zoneSwitchScopes = Collections.unmodifiableList(Arrays.asList("zones.{zone_id}.admin", "zones.{zone_id}.read", "zones.{zone_id}.clients.admin", "zones.{zone_id}.clients.read", "zones.{zone_id}.clients.write", "zones.{zone_id}.scim.read", "zones.{zone_id}.scim.write", "zones.{zone_id}.scim.create", "zones.{zone_id}.idps.read"));
    public static final List<String> zoneScopestoNotStripPrefix = Collections.unmodifiableList(Arrays.asList("admin", "read"));

    @Autowired
    public IdentityZoneSwitchingFilter(IdentityZoneProvisioning dao) {
        this.dao = dao;
    }

    protected boolean isAuthorizedToSwitchToIdentityZone(String identityZoneId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean hasScope = OAuth2ExpressionUtils.hasAnyScope((Authentication)authentication, (String[])this.getZoneSwitchingScopes(identityZoneId));
        boolean isUaa = IdentityZoneHolder.isUaa();
        boolean isTokenAuth = authentication instanceof OAuth2Authentication;
        return isTokenAuth && isUaa && hasScope;
    }

    protected void stripScopesFromAuthentication(String identityZoneId, HttpServletRequest servletRequest) {
        OAuth2Authentication oa = (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
        Object oaDetails = oa.getDetails();
        OAuth2Request request = oa.getOAuth2Request();
        Set<String> requestAuthorities = UaaStringUtils.getStringsFromAuthorities(request.getAuthorities());
        HashSet<String> clientScopes = new HashSet<String>();
        HashSet<String> clientAuthorities = new HashSet<String>();
        for (String s : this.getZoneSwitchingScopes(identityZoneId)) {
            String scope = this.stripPrefix(s, identityZoneId);
            if (request.getScope().contains(s)) {
                clientScopes.add(scope);
            }
            if (!requestAuthorities.contains(s)) continue;
            clientAuthorities.add(scope);
        }
        request = new OAuth2Request(request.getRequestParameters(), request.getClientId(), UaaStringUtils.getAuthoritiesFromStrings(clientAuthorities), request.isApproved(), clientScopes, request.getResourceIds(), request.getRedirectUri(), request.getResponseTypes(), request.getExtensions());
        UaaAuthentication userAuthentication = (UaaAuthentication)oa.getUserAuthentication();
        if (userAuthentication != null) {
            userAuthentication = new UaaAuthentication(userAuthentication.getPrincipal(), null, UaaStringUtils.getAuthoritiesFromStrings(clientScopes), new UaaAuthenticationDetails(servletRequest), true, userAuthentication.getAuthenticatedTime());
        }
        oa = new OAuth2Authentication(request, (Authentication)userAuthentication);
        oa.setDetails(oaDetails);
        SecurityContextHolder.getContext().setAuthentication((Authentication)oa);
    }

    protected String stripPrefix(String s, String identityZoneId) {
        if (!StringUtils.hasText((String)s)) {
            return s;
        }
        String replace = ZONES_ZONE_ID_PREFIX + identityZoneId + ".";
        for (String scope : zoneScopestoNotStripPrefix) {
            if (!s.equals(replace + scope)) continue;
            return s;
        }
        if (s.startsWith(replace)) {
            return s.substring(replace.length());
        }
        return s;
    }

    protected String[] getZoneSwitchingScopes(String identityZoneId) {
        String[] result = new String[zoneSwitchScopes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = zoneSwitchScopes.get(i).replace(ZONE_ID_MATCH, identityZoneId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String identityZoneIdFromHeader = request.getHeader(HEADER);
        String identityZoneSubDomain = request.getHeader(SUBDOMAIN_HEADER);
        if (StringUtils.isEmpty((Object)identityZoneIdFromHeader) && StringUtils.isEmpty((Object)identityZoneSubDomain)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        IdentityZone identityZone = this.validateIdentityZone(identityZoneIdFromHeader, identityZoneSubDomain);
        if (identityZone == null) {
            response.sendError(404, "Identity zone with id/subdomain " + identityZoneIdFromHeader + "/" + identityZoneSubDomain + " does not exist");
            return;
        }
        String identityZoneId = identityZone.getId();
        if (!this.isAuthorizedToSwitchToIdentityZone(identityZoneId)) {
            response.sendError(403, "User is not authorized to switch to IdentityZone with id " + identityZoneId);
            return;
        }
        IdentityZone originalIdentityZone = IdentityZoneHolder.get();
        try {
            this.stripScopesFromAuthentication(identityZoneId, request);
            IdentityZoneHolder.set(identityZone);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            IdentityZoneHolder.set(originalIdentityZone);
        }
    }

    private IdentityZone validateIdentityZone(String identityZoneId, String identityZoneSubDomain) throws IOException {
        IdentityZone identityZone = null;
        try {
            identityZone = StringUtils.isEmpty((Object)identityZoneId) ? this.dao.retrieveBySubdomain(identityZoneSubDomain) : this.dao.retrieve(identityZoneId);
        }
        catch (ZoneDoesNotExistsException | EmptyResultDataAccessException throwable) {
        }
        catch (Exception ex) {
            throw ex;
        }
        return identityZone;
    }
}

