/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class AuthzAuthenticationFilter
implements Filter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private AuthenticationManager authenticationManager;
    private List<String> parameterNames = Collections.emptyList();
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private Set<String> methods = Collections.singleton(HttpMethod.POST.toString());

    public void setMethods(Set<String> methods) {
        this.methods = new HashSet<String>();
        for (String method : methods) {
            this.methods.add(method.toUpperCase());
        }
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public AuthzAuthenticationFilter(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager);
        this.authenticationManager = authenticationManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        Map<String, String> loginInfo = this.getCredentials(req);
        boolean buggyVmcAcceptHeader = false;
        try {
            if (loginInfo.isEmpty()) {
                throw new BadCredentialsException("Request does not contain credentials.");
            }
            this.logger.debug((Object)("Located credentials in request, with keys: " + loginInfo.keySet()));
            if (this.methods != null && !this.methods.contains(req.getMethod().toUpperCase())) {
                throw new BadCredentialsException("Credentials must be sent by (one of methods): " + this.methods);
            }
            Authentication result = this.authenticationManager.authenticate((Authentication)new AuthzAuthenticationRequest(loginInfo, new UaaAuthenticationDetails(req)));
            SecurityContextHolder.getContext().setAuthentication(result);
        }
        catch (AuthenticationException e) {
            this.logger.debug((Object)"Authentication failed");
            String acceptHeaderValue = req.getHeader("accept");
            String clientId = req.getParameter("client_id");
            if ("*/*; q=0.5, application/xml".equals(acceptHeaderValue) && "vmc".equals(clientId)) {
                buggyVmcAcceptHeader = true;
            }
            if (buggyVmcAcceptHeader) {
                HttpServletRequestWrapper jsonAcceptingRequest = new HttpServletRequestWrapper(req){

                    public Enumeration<String> getHeaders(String name) {
                        if ("accept".equalsIgnoreCase(name)) {
                            return new JsonInjectedEnumeration(((HttpServletRequest)this.getRequest()).getHeaders(name));
                        }
                        return ((HttpServletRequest)this.getRequest()).getHeaders(name);
                    }

                    public String getHeader(String name) {
                        if (name.equalsIgnoreCase("accept")) {
                            return "application/json";
                        }
                        return ((HttpServletRequest)this.getRequest()).getHeader(name);
                    }
                };
                this.authenticationEntryPoint.commence((HttpServletRequest)jsonAcceptingRequest, res, e);
            } else {
                this.authenticationEntryPoint.commence(req, res, e);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    private Map<String, String> getCredentials(HttpServletRequest request) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        for (String paramName : this.parameterNames) {
            String value = request.getParameter(paramName);
            if (value == null) continue;
            if (value.startsWith("{")) {
                try {
                    Map jsonCredentials = (Map)JsonUtils.readValue((String)value, (TypeReference)new TypeReference<Map<String, String>>(){});
                    credentials.putAll(jsonCredentials);
                }
                catch (JsonUtils.JsonUtilException e) {
                    this.logger.warn((Object)("Unknown format of value for request param: " + paramName + ". Ignoring."));
                }
                continue;
            }
            credentials.put(paramName, value);
        }
        return credentials;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    static class JsonInjectedEnumeration
    implements Enumeration<String> {
        private Enumeration<String> underlying;

        public JsonInjectedEnumeration(Enumeration<String> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean hasMoreElements() {
            return this.underlying.hasMoreElements();
        }

        @Override
        public String nextElement() {
            this.underlying.nextElement();
            return "application/json";
        }
    }
}

