/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.event;

import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.authentication.event.AbstractUaaAuthenticationEvent;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class UserAuthenticationFailureEvent
extends AbstractUaaAuthenticationEvent {
    private final UaaUser user;

    public UserAuthenticationFailureEvent(UaaUser user, Authentication authentication) {
        super(authentication);
        Assert.notNull((Object)user, (String)"UaaUser object cannot be null");
        this.user = user;
    }

    @Override
    public AuditEvent getAuditEvent() {
        if (this.user == null) {
            return this.createAuditRecord("<UNKNOWN>", AuditEventType.UserNotFound, this.getOrigin(this.getAuthenticationDetails()), this.user.getUsername());
        }
        return this.createAuditRecord(this.user.getId(), AuditEventType.UserAuthenticationFailure, this.getOrigin(this.getAuthenticationDetails()), this.user.getUsername());
    }

    public UaaUser getUser() {
        return this.user;
    }
}

