/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ChainedAuthenticationManager
implements AuthenticationManager {
    public static final String IF_PREVIOUS_FALSE = "ifPreviousFalse";
    public static final String IF_PREVIOUS_TRUE = "ifPreviousTrue";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private AuthenticationManagerConfiguration[] delegates;

    public AuthenticationManagerConfiguration[] getDelegates() {
        return this.delegates;
    }

    public void setDelegates(AuthenticationManagerConfiguration[] delegates) {
        this.delegates = delegates;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication == null) {
            return authentication;
        }
        UsernamePasswordAuthenticationToken output = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            output = (UsernamePasswordAuthenticationToken)authentication;
        } else {
            output = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
            output.setDetails(authentication.getDetails());
        }
        boolean authenticated = false;
        UsernamePasswordAuthenticationToken auth = null;
        AuthenticationException lastException = null;
        boolean lastResult = false;
        boolean shallContinue = true;
        for (int i = 0; shallContinue && i < this.delegates.length; ++i) {
            boolean shallAuthenticate;
            boolean bl = shallAuthenticate = i == 0 || lastResult && IF_PREVIOUS_TRUE.equals(this.delegates[i].getRequired()) || !lastResult && IF_PREVIOUS_FALSE.equals(this.delegates[i].getRequired());
            if (shallAuthenticate) {
                Authentication thisAuth;
                block15: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Attempting chained authentication of " + output + " with manager:" + this.delegates[i].getAuthenticationManager() + " required:" + this.delegates[i].getRequired()));
                    }
                    thisAuth = null;
                    try {
                        thisAuth = this.delegates[i].getAuthenticationManager().authenticate((Authentication)(auth != null ? auth : output));
                    }
                    catch (AuthenticationException x) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Chained authentication exception:" + x.getMessage() + " at:" + (x.getStackTrace().length > 0 ? x.getStackTrace()[0] : "(no stack trace)")));
                        }
                        lastException = x;
                        if (this.delegates[i].getStopIf() == null) break block15;
                        for (Class<? extends AuthenticationException> exceptionClass : this.delegates[i].getStopIf()) {
                            if (!exceptionClass.isAssignableFrom(((Object)((Object)x)).getClass())) continue;
                            shallContinue = false;
                            break;
                        }
                    }
                }
                boolean bl2 = lastResult = thisAuth != null && thisAuth.isAuthenticated();
                if (lastResult) {
                    authenticated = true;
                    auth = thisAuth;
                } else {
                    authenticated = false;
                    auth = null;
                }
            } else {
                shallContinue = false;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Chained Authentication status of " + output + " with manager:" + this.delegates[i] + "; Authenticated:" + authenticated));
        }
        if (authenticated) {
            return auth;
        }
        if (lastException != null) {
            throw lastException;
        }
        return auth;
    }

    public static class AuthenticationManagerConfiguration {
        private AuthenticationManager authenticationManager;
        private String required = null;
        private Class<? extends AuthenticationException>[] stopIf;

        public Class<? extends AuthenticationException>[] getStopIf() {
            return this.stopIf;
        }

        public void setStopIf(Class<? extends AuthenticationException> ... stopIf) {
            this.stopIf = stopIf;
        }

        public AuthenticationManagerConfiguration() {
        }

        public AuthenticationManagerConfiguration(AuthenticationManager authenticationManager, String required) {
            this.authenticationManager = authenticationManager;
            this.required = required;
        }

        public AuthenticationManager getAuthenticationManager() {
            return this.authenticationManager;
        }

        public void setAuthenticationManager(AuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
        }

        public String getRequired() {
            return this.required;
        }

        public void setRequired(String required) {
            boolean valid = false;
            if (ChainedAuthenticationManager.IF_PREVIOUS_FALSE.equals(required) || ChainedAuthenticationManager.IF_PREVIOUS_TRUE.equals(required)) {
                valid = true;
            }
            if (!valid) {
                throw new IllegalArgumentException(required + " is not a valid value for property 'required'");
            }
            this.required = required;
        }
    }
}

