/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.invitations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SortOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordChangeRequest;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.invitations.InvitationsService;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring4.SpringTemplateEngine;

@Service
public class EmailInvitationsService
implements InvitationsService {
    public static final String USER_ID = "user_id";
    public static final String EMAIL = "email";
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final int INVITATION_EXPIRY_DAYS = 7;
    private final SpringTemplateEngine templateEngine;
    private final MessageService messageService;
    @Autowired
    private ScimUserProvisioning scimUserProvisioning;
    private String brand;
    @Autowired
    private ExpiringCodeStore expiringCodeStore;
    @Autowired
    private ClientDetailsService clientDetailsService;

    public EmailInvitationsService(SpringTemplateEngine templateEngine, MessageService messageService, String brand) {
        this.templateEngine = templateEngine;
        this.messageService = messageService;
        this.brand = brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    private void sendInvitationEmail(String email, String currentUser, String code) {
        String subject = this.getSubjectText();
        try {
            String htmlContent = this.getEmailHtml(currentUser, code);
            this.messageService.sendMessage(email, MessageType.INVITATION, subject, htmlContent);
        }
        catch (RestClientException e) {
            this.logger.info((Object)("Exception raised while creating invitation email from " + email), (Throwable)e);
        }
    }

    private String getSubjectText() {
        return this.brand.equals("pivotal") ? "Invitation to join Pivotal" : "Invitation to join Cloud Foundry";
    }

    private String getEmailHtml(String currentUser, String code) {
        String accountsUrl = ServletUriComponentsBuilder.fromCurrentContextPath().path("/invitations/accept").build().toUriString();
        Context ctx = new Context();
        ctx.setVariable("serviceName", (Object)(this.brand.equals("pivotal") ? "Pivotal" : "Cloud Foundry"));
        ctx.setVariable("code", (Object)code);
        ctx.setVariable("currentUser", (Object)currentUser);
        ctx.setVariable("accountsUrl", (Object)accountsUrl);
        return this.templateEngine.process("invite", (IContext)ctx);
    }

    @Override
    public InvitationsService.AcceptedInvitation acceptInvitation(String code, String password) {
        ExpiringCode data = this.expiringCodeStore.retrieveCode(code);
        Map userData = (Map)JsonUtils.readValue((String)data.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        String userId = (String)userData.get(USER_ID);
        String clientId = (String)userData.get("client_id");
        String redirectUri = (String)userData.get("redirect_uri");
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        if ("uaa".equals((user = this.scimUserProvisioning.verifyUser(userId, user.getVersion())).getOrigin())) {
            PasswordChangeRequest request = new PasswordChangeRequest();
            request.setPassword(password);
            this.scimUserProvisioning.changePassword(userId, null, password);
        }
        String redirectLocation = "/home";
        try {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
            Set redirectUris = clientDetails.getRegisteredRedirectUri();
            String matchingRedirectUri = UaaUrlUtils.findMatchingRedirectUri(redirectUris, redirectUri);
            if (StringUtils.hasText((String)matchingRedirectUri)) {
                redirectLocation = redirectUri;
            }
        }
        catch (NoSuchClientException x) {
            this.logger.debug((Object)("Unable to find client_id for invitation:" + clientId));
        }
        catch (Exception x) {
            this.logger.error((Object)("Unable to resolve redirect for clientID:" + clientId), (Throwable)x);
        }
        return new InvitationsService.AcceptedInvitation(redirectLocation, user);
    }

    private boolean usernameIsEmail(ScimUser user) {
        return user.getUserName().contains("@");
    }

    private ScimUser getMostRecentUserWithMatchingEmail(ScimUser user) {
        String filter = "email eq " + user.getPrimaryEmail();
        List queriedUsers = this.scimUserProvisioning.query(filter, "created", SortOrder.DESCENDING.equals((Object)SortOrder.ASCENDING));
        if (queriedUsers != null) {
            for (ScimUser queriedUser : queriedUsers) {
                if (this.usernameIsEmail(queriedUser)) continue;
                return queriedUser;
            }
        }
        return null;
    }
}

