/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import org.springframework.util.StringUtils;

public class Prompt {
    private final String name;
    private final String text;
    private final String type;

    public Prompt(String name, String type, String text) {
        this.name = name;
        this.type = type;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDetails() {
        return new String[]{this.type, this.text};
    }

    public static Prompt valueOf(String text) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        String[] parts = text.split(":");
        if (parts.length < 2) {
            return null;
        }
        String name = parts[0].replaceAll("\"", "");
        String[] values = parts[1].replaceAll("\"", "").replaceAll("\\[", "").replaceAll("\\]", "").split(",");
        values = StringUtils.trimArrayElements((String[])values);
        return new Prompt(name, values[0], values[1]);
    }

    public String toString() {
        return String.format("\"%s\":[\"%s\",\"%s\"]", this.name, this.type, this.text);
    }

    public int hashCode() {
        return 31 + this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Prompt other = (Prompt)obj;
        return this.toString().equals(other.toString());
    }
}

