/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.token.Claims;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CheckTokenEndpoint
implements InitializingBean {
    private ResourceServerTokenServices resourceServerTokenServices;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();

    public void setTokenServices(ResourceServerTokenServices resourceServerTokenServices) {
        this.resourceServerTokenServices = resourceServerTokenServices;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resourceServerTokenServices, (String)"tokenServices must be set");
    }

    @RequestMapping(value={"/check_token"})
    @ResponseBody
    public Claims checkToken(@RequestParam(value="token") String value) {
        OAuth2AccessToken token = this.resourceServerTokenServices.readAccessToken(value);
        if (token == null) {
            throw new InvalidTokenException("Token was not recognised");
        }
        if (token.isExpired()) {
            throw new InvalidTokenException("Token has expired");
        }
        try {
            this.resourceServerTokenServices.loadAuthentication(value);
        }
        catch (AuthenticationException x) {
            throw new InvalidTokenException(x.getMessage());
        }
        Claims response = this.getClaimsForToken(value);
        return response;
    }

    private Claims getClaimsForToken(String token) {
        Jwt tokenJwt = null;
        try {
            tokenJwt = JwtHelper.decode((String)token);
        }
        catch (Throwable t) {
            throw new InvalidTokenException("Invalid token (could not decode): " + token);
        }
        Claims claims = null;
        try {
            claims = (Claims)JsonUtils.readValue((String)tokenJwt.getClaims(), Claims.class);
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot read token claims", e);
        }
        return claims;
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        InvalidTokenException e400 = new InvalidTokenException(e.getMessage()){

            public int getHttpErrorCode() {
                return 400;
            }
        };
        return this.exceptionTranslator.translate((Exception)e400);
    }
}

