/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaSigner;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;

public class SignerProvider
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String verifierKey;
    private String signingKey = this.verifierKey = new RandomValueStringGenerator().generate();
    private Signer signer = new MacSigner(this.verifierKey);
    private String type = "MAC";

    public void afterPropertiesSet() throws Exception {
        if (this.signer instanceof RsaSigner) {
            RsaVerifier verifier;
            this.type = "RSA";
            try {
                verifier = new RsaVerifier(this.verifierKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create an RSA verifier from verifierKey", e);
            }
            byte[] test = "test".getBytes();
            try {
                verifier.verify(test, this.signer.sign(test));
                this.logger.debug((Object)"Signing and verification RSA keys match");
            }
            catch (InvalidSignatureException e) {
                throw new RuntimeException("Signing and verification RSA keys do not match", e);
            }
        }
        Assert.state((this.signingKey == this.verifierKey ? 1 : 0) != 0, (String)"For MAC signing you do not need to specify the verifier key separately, and if you do it must match the signing key");
    }

    public Signer getSigner() {
        return this.signer;
    }

    public String getVerifierKey() {
        return this.verifierKey;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPublic() {
        return this.verifierKey.startsWith("-----BEGIN");
    }

    public SignatureVerifier getVerifier() {
        if (this.isAssymetricKey(this.signingKey)) {
            return new RsaVerifier(this.verifierKey);
        }
        return new MacSigner(this.verifierKey);
    }

    public String getRevocationHash(List<String> salts) {
        String result = "";
        for (String s : salts) {
            byte[] hashable = (result + "###" + s).getBytes();
            result = Integer.toHexString(SignerProvider.murmurhash3x8632(hashable, 0, hashable.length, 61680));
        }
        return result;
    }

    public void setSigningKey(String key) {
        Assert.hasText((String)key);
        this.signingKey = key = key.trim();
        if (this.isAssymetricKey(key)) {
            this.signer = new RsaSigner(key);
            this.logger.debug((Object)"Configured with RSA signing key");
        } else {
            this.verifierKey = key;
            this.signer = new MacSigner(key);
        }
    }

    private boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }

    public void setVerifierKey(String verifierKey) {
        boolean valid = false;
        try {
            new RsaSigner(verifierKey);
        }
        catch (Exception expected) {
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("Private key cannot be set as verifierKey property");
        }
        this.verifierKey = verifierKey;
    }

    public static int murmurhash3x8632(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

