/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.zone.MultitenantJdbcClientDetailsService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class TokenRevocationEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();
    private final ScimUserProvisioning userProvisioning;
    private final MultitenantJdbcClientDetailsService clientDetailsService;
    private final RandomValueStringGenerator generator = new RandomValueStringGenerator(8);

    public TokenRevocationEndpoint(MultitenantJdbcClientDetailsService clientDetailsService, ScimUserProvisioning userProvisioning) {
        this.clientDetailsService = clientDetailsService;
        this.userProvisioning = userProvisioning;
    }

    @RequestMapping(value={"/oauth/token/revoke/user/{userId}"})
    public ResponseEntity<Void> revokeTokensForUser(@PathVariable String userId) {
        this.logger.debug((Object)("Revoking tokens for user: " + userId));
        ScimUser user = (ScimUser)this.userProvisioning.retrieve(userId);
        user.setSalt(this.generator.generate());
        this.userProvisioning.update(userId, user);
        this.logger.debug((Object)("Tokens revoked for user: " + userId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/client/{clientId}"})
    public ResponseEntity<Void> revokeTokensForClient(@PathVariable String clientId) {
        this.logger.debug((Object)("Revoking tokens for client: " + clientId));
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId);
        client.addAdditionalInformation("token_salt", (Object)this.generator.generate());
        this.clientDetailsService.updateClientDetails((ClientDetails)client);
        this.logger.debug((Object)("Tokens revoked for client: " + clientId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @ExceptionHandler(value={ScimResourceNotFoundException.class, NoSuchClientException.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        InvalidTokenException e404 = new InvalidTokenException("Resource not found"){

            public int getHttpErrorCode() {
                return 404;
            }
        };
        return this.exceptionTranslator.translate((Exception)e404);
    }
}

