/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;

public interface ComparableProvider
extends Comparable<ComparableProvider> {
    public String getAlias();

    public String getZoneId();

    public XMLObject doGetMetadata() throws MetadataProviderException;

    public byte[] fetchMetadata() throws MetadataProviderException;

    default public String getEntityID() throws MetadataProviderException {
        this.fetchMetadata();
        XMLObject metadata = this.doGetMetadata();
        if (metadata instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)metadata;
            return entityDescriptor.getEntityID();
        }
        if (metadata instanceof EntitiesDescriptor) {
            EntitiesDescriptor desc = (EntitiesDescriptor)metadata;
            if (desc.getEntityDescriptors().size() != 1) {
                throw new MetadataProviderException("Invalid metadata. Number of descriptors must be 1, but is " + desc.getEntityDescriptors().size());
            }
            return ((EntityDescriptor)desc.getEntityDescriptors().get(0)).getEntityID();
        }
        throw new MetadataProviderException("Unknown descriptor class:" + metadata.getClass().getName());
    }

    @Override
    default public int compareTo(ComparableProvider that) {
        if (this == that) {
            return 0;
        }
        int result = this.getAlias().compareTo(that.getAlias());
        if (0 != result) {
            return result;
        }
        result = this.getZoneId().compareTo(that.getZoneId());
        if (0 != result) {
            return result;
        }
        return 0;
    }

    default public int getHashCode() {
        int result = this.getZoneId().hashCode();
        result = 31 * result + this.getAlias().hashCode();
        return result;
    }
}

