/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;

public class FixedHttpMetaDataProvider
extends HTTPMetadataProvider {
    private boolean socketFactorySet = false;
    private byte[] metadata;

    public FixedHttpMetaDataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL) throws MetadataProviderException {
        super(backgroundTaskTimer, client, metadataURL);
    }

    public byte[] fetchMetadata() throws MetadataProviderException {
        if (this.metadata == null) {
            this.metadata = super.fetchMetadata();
        }
        return this.metadata;
    }

    public void setSocketFactory(ProtocolSocketFactory newSocketFactory) {
        super.setSocketFactory(newSocketFactory);
        this.socketFactorySet = newSocketFactory != null;
    }

    public String getMetadataURI() {
        if (this.isSocketFactorySet()) {
            try {
                URI uri = new URI(super.getMetadataURI());
                String result = uri.getPath();
                if (uri.getQuery() != null && uri.getQuery().trim().length() > 0) {
                    result = result + "?" + uri.getQuery();
                }
                return result;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return super.getMetadataURI();
    }

    public boolean isSocketFactorySet() {
        return this.socketFactorySet;
    }
}

