/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;

public class SamlLoginServerKeyManager
implements KeyManager {
    protected static final Logger logger = LoggerFactory.getLogger(SamlLoginServerKeyManager.class);
    private JKSKeyManager keyManager = null;

    public SamlLoginServerKeyManager(String key, String password, String certificate) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (null == password) {
            password = "";
        }
        try {
            PEMReader reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(certificate.getBytes())));
            X509Certificate cert = (X509Certificate)reader.readObject();
            reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(key.getBytes())), (PasswordFinder)new StringPasswordFinder(password));
            KeyPair pkey = (KeyPair)reader.readObject();
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(null);
            keystore.setCertificateEntry("service-provider-cert", cert);
            keystore.setKeyEntry("service-provider-cert", pkey.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, password.toCharArray());
            this.keyManager = new JKSKeyManager(keystore, Collections.singletonMap("service-provider-cert", password), "service-provider-cert");
            if (null == this.keyManager) {
                throw new IllegalArgumentException("Could not load service provider certificate. Check serviceProviderKey and certificate parameters");
            }
            logger.info("Loaded service provider certificate " + this.keyManager.getDefaultCredentialName());
        }
        catch (Throwable t) {
            logger.error("Could not load certificate", t);
            throw new IllegalArgumentException("Could not load service provider certificate. Check serviceProviderKey and certificate parameters", t);
        }
    }

    public Iterable<Credential> resolve(CriteriaSet criteria) throws SecurityException {
        return this.keyManager.resolve(criteria);
    }

    public Credential resolveSingle(CriteriaSet criteria) throws SecurityException {
        return this.keyManager.resolveSingle(criteria);
    }

    public Credential getCredential(String keyName) {
        return this.keyManager.getCredential(keyName);
    }

    public Credential getDefaultCredential() {
        return this.keyManager.getDefaultCredential();
    }

    public String getDefaultCredentialName() {
        return this.keyManager.getDefaultCredentialName();
    }

    public Set<String> getAvailableCredentials() {
        return this.keyManager.getAvailableCredentials();
    }

    public X509Certificate getCertificate(String alias) {
        return this.keyManager.getCertificate(alias);
    }

    private class StringPasswordFinder
    implements PasswordFinder {
        private String password = null;

        public StringPasswordFinder(String password) {
            this.password = password;
        }

        public char[] getPassword() {
            return this.password.toCharArray();
        }
    }
}

