/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.ZoneAlreadyExistsException;
import org.cloudfoundry.identity.uaa.zone.ZoneDoesNotExistsException;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.flywaydb.core.internal.util.StringUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;

public class StoreSubDomainAsLowerCase_V2_7_3
implements SpringJdbcMigration {
    static final String ID_ZONE_FIELDS = "id,version,created,lastmodified,name,subdomain,description";
    static final String IDENTITY_ZONES_QUERY = "select id,version,created,lastmodified,name,subdomain,description from identity_zone ";
    Log logger = LogFactory.getLog(StoreSubDomainAsLowerCase_V2_7_3.class);
    private RowMapper<IdentityZone> mapper = (rs, rowNum) -> {
        IdentityZone identityZone = new IdentityZone();
        identityZone.setId(rs.getString(1).trim());
        identityZone.setVersion(rs.getInt(2));
        identityZone.setCreated((Date)rs.getTimestamp(3));
        identityZone.setLastModified((Date)rs.getTimestamp(4));
        identityZone.setName(rs.getString(5));
        identityZone.setSubdomain(rs.getString(6));
        identityZone.setDescription(rs.getString(7));
        return identityZone;
    };

    public synchronized void migrate(JdbcTemplate jdbcTemplate) throws Exception {
        RandomValueStringGenerator generator = new RandomValueStringGenerator(3);
        HashMap<String, List<IdentityZone>> zones = new HashMap<String, List<IdentityZone>>();
        HashSet<String> duplicates = new HashSet<String>();
        List<IdentityZone> identityZones = this.retrieveIdentityZones(jdbcTemplate);
        for (IdentityZone zone : identityZones) {
            this.addToMap(zone, zones, duplicates);
        }
        for (String s : duplicates) {
            this.logger.debug((Object)("Processing zone duplicates for subdomain:" + s));
            List dupZones = (List)zones.get(s);
            for (int i = 1; dupZones.size() > 1 && i < dupZones.size(); ++i) {
                IdentityZone dupZone = (IdentityZone)dupZones.get(i);
                String newsubdomain = null;
                while (newsubdomain == null) {
                    String potentialsubdomain = (dupZone.getSubdomain() + "-" + generator.generate()).toLowerCase();
                    if (zones.get(potentialsubdomain) != null) continue;
                    newsubdomain = potentialsubdomain;
                }
                this.logger.debug((Object)String.format("Updating zone id:%s; old subdomain: %s; new subdomain: %s;", dupZone.getId(), dupZone.getSubdomain(), newsubdomain));
                dupZone.setSubdomain(newsubdomain);
                dupZone = this.updateIdentityZone(dupZone, jdbcTemplate);
                zones.put(newsubdomain, Arrays.asList(dupZone));
            }
        }
        for (IdentityZone zone : identityZones) {
            String subdomain = zone.getSubdomain();
            if (!StringUtils.hasText((String)subdomain) || subdomain.toLowerCase().equals(subdomain)) continue;
            this.logger.debug((Object)String.format("Lowercasing zone subdomain for id:%s; old subdomain: %s; new subdomain: %s;", zone.getId(), zone.getSubdomain(), zone.getSubdomain().toLowerCase()));
            zone.setSubdomain(subdomain.toLowerCase());
            this.updateIdentityZone(zone, jdbcTemplate);
        }
    }

    private IdentityZone updateIdentityZone(final IdentityZone identityZone, JdbcTemplate jdbcTemplate) {
        String ID_ZONE_UPDATE_FIELDS = "version,lastmodified,name,subdomain,description".replace(",", "=?,") + "=?";
        String UPDATE_IDENTITY_ZONE_SQL = "update identity_zone set " + ID_ZONE_UPDATE_FIELDS + " where id=?";
        try {
            jdbcTemplate.update(UPDATE_IDENTITY_ZONE_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setInt(1, identityZone.getVersion() + 1);
                    ps.setTimestamp(2, new Timestamp(new Date().getTime()));
                    ps.setString(3, identityZone.getName());
                    ps.setString(4, identityZone.getSubdomain().toLowerCase());
                    ps.setString(5, identityZone.getDescription());
                    ps.setString(6, identityZone.getId().trim());
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new ZoneAlreadyExistsException(e.getMostSpecificCause().getMessage(), e);
        }
        return this.retrieveIdentityZone(identityZone.getId(), jdbcTemplate);
    }

    private IdentityZone retrieveIdentityZone(String id, JdbcTemplate jdbcTemplate) {
        String IDENTITY_ZONE_BY_ID_QUERY = "select id,version,created,lastmodified,name,subdomain,description from identity_zone where id=?";
        try {
            IdentityZone identityZone = (IdentityZone)jdbcTemplate.queryForObject(IDENTITY_ZONE_BY_ID_QUERY, this.mapper, new Object[]{id});
            return identityZone;
        }
        catch (EmptyResultDataAccessException x) {
            throw new ZoneDoesNotExistsException("Zone[" + id + "] not found.", x);
        }
    }

    private List<IdentityZone> retrieveIdentityZones(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.query(IDENTITY_ZONES_QUERY, this.mapper);
    }

    private void addToMap(IdentityZone zone, Map<String, List<IdentityZone>> zones, Set<String> duplicates) {
        if (zone == null || zone.getSubdomain() == null) {
            return;
        }
        String subdomain = zone.getSubdomain().toLowerCase();
        if (zones.get(subdomain) == null) {
            LinkedList<IdentityZone> list = new LinkedList<IdentityZone>();
            list.add(zone);
            zones.put(subdomain, list);
        } else {
            this.logger.warn((Object)("Found duplicate zone for subdomain:" + subdomain));
            duplicates.add(subdomain);
            zones.get(subdomain).add(zone);
        }
    }
}

