/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.home;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.client.ClientMetadata;
import org.cloudfoundry.identity.uaa.client.JdbcClientMetadataProvisioning;
import org.cloudfoundry.identity.uaa.home.TileInfo;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HomeController {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected final Environment environment;
    private Map<String, String> links = new HashMap<String, String>();
    private String baseUrl;
    @Autowired
    private JdbcClientMetadataProvisioning clientMetadataProvisioning;
    @Autowired
    private TileInfo tileInfo;

    public HomeController(Environment environment) {
        this.environment = environment;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setUaaBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getUaaBaseUrl() {
        return this.baseUrl;
    }

    protected Map<String, ?> getLinksInfo() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("uaa", this.getUaaBaseUrl());
        model.put("login", this.getUaaBaseUrl().replaceAll("uaa", "login"));
        model.putAll(this.getLinks());
        return model;
    }

    protected void populateBuildAndLinkInfo(Model model) {
        HashMap attributes = new HashMap();
        attributes.put("links", this.getLinksInfo());
        model.addAllAttributes(attributes);
        model.addAttribute("links", this.getLinks());
    }

    @RequestMapping(value={"/", "/home"})
    public String home(Model model, Principal principal) {
        boolean invitationsEnabled;
        String homePage = this.environment.getProperty("login.homeRedirect");
        if (homePage != null) {
            return "redirect:" + homePage;
        }
        model.addAttribute("principal", (Object)principal);
        ArrayList tiles = new ArrayList();
        if (IdentityZoneHolder.isUaa()) {
            List<ClientMetadata> clientMetadataList = this.clientMetadataProvisioning.retrieveAll();
            clientMetadataList.stream().filter(clientMetadata -> clientMetadata.isShowOnHomePage()).map(data -> new TileData(data.getClientId(), data.getAppLaunchUrl().toString(), "data:image/png;base64," + data.getAppIcon(), StringUtils.hasText((String)data.getClientName()) ? data.getClientName() : data.getClientId())).forEach(tile -> tiles.add(tile));
            this.tileInfo.getLoginTiles().stream().map(tile -> new TileData((String)tile.get("name"), (String)tile.get("login-link"), (String)tile.get("image"), (String)tile.get("name"))).forEach(tile -> tiles.add(tile));
            model.addAttribute("tiles", tiles);
        }
        if (invitationsEnabled = "true".equalsIgnoreCase(this.environment.getProperty("login.invitationsEnabled"))) {
            model.addAttribute("invitationsLink", (Object)"/invitations/new");
        }
        this.populateBuildAndLinkInfo(model);
        return "home";
    }

    @RequestMapping(value={"/error500"})
    public String error500(Model model, HttpServletRequest request) {
        this.logger.error((Object)"Internal error", (Throwable)request.getAttribute("javax.servlet.error.exception"));
        this.populateBuildAndLinkInfo(model);
        return "error";
    }

    @RequestMapping(value={"/error404"})
    public String error404(Model model) {
        this.populateBuildAndLinkInfo(model);
        return "error";
    }

    @RequestMapping(value={"/saml_error"})
    public String error401(Model model, HttpServletRequest request) {
        AuthenticationException exception = (AuthenticationException)((Object)request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION"));
        model.addAttribute("saml_error", (Object)exception.getMessage());
        return "saml_error";
    }

    private static class TileData {
        private String appLaunchUrl;
        private String appIcon;
        private String clientId;
        private String clientName;

        private TileData(String clientId, String appLaunchUrl, String appIcon, String clientName) {
            this.appLaunchUrl = appLaunchUrl;
            this.appIcon = appIcon;
            this.clientId = clientId;
            this.clientName = clientName;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getAppIcon() {
            return this.appIcon;
        }

        public String getAppLaunchUrl() {
            return this.appLaunchUrl;
        }

        public String getClientName() {
            return this.clientName;
        }
    }
}

