/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.invitations;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordChangeRequest;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.invitations.InvitationsService;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class EmailInvitationsService
implements InvitationsService {
    public static final String USER_ID = "user_id";
    public static final String EMAIL = "email";
    private final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ScimUserProvisioning scimUserProvisioning;
    @Autowired
    private ExpiringCodeStore expiringCodeStore;
    @Autowired
    private ClientDetailsService clientDetailsService;

    @Override
    public InvitationsService.AcceptedInvitation acceptInvitation(String code, String password) {
        ExpiringCode data = this.expiringCodeStore.retrieveCode(code);
        Map userData = (Map)JsonUtils.readValue((String)data.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
        String userId = (String)userData.get(USER_ID);
        String clientId = (String)userData.get("client_id");
        String redirectUri = (String)userData.get("redirect_uri");
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        if ("uaa".equals((user = this.scimUserProvisioning.verifyUser(userId, user.getVersion())).getOrigin())) {
            PasswordChangeRequest request = new PasswordChangeRequest();
            request.setPassword(password);
            this.scimUserProvisioning.changePassword(userId, null, password);
        }
        String redirectLocation = "/home";
        try {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
            Set redirectUris = clientDetails.getRegisteredRedirectUri();
            String matchingRedirectUri = UaaUrlUtils.findMatchingRedirectUri(redirectUris, redirectUri);
            if (StringUtils.hasText((String)matchingRedirectUri)) {
                redirectLocation = redirectUri;
            }
        }
        catch (NoSuchClientException x) {
            this.logger.debug((Object)("Unable to find client_id for invitation:" + clientId));
        }
        catch (Exception x) {
            this.logger.error((Object)("Unable to resolve redirect for clientID:" + clientId), (Throwable)x);
        }
        return new InvitationsService.AcceptedInvitation(redirectLocation, user);
    }
}

