/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.lang.reflect.Field;
import java.security.Principal;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.SignerProvider;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeyResponse;
import org.cloudfoundry.identity.uaa.oauth.token.VerificationKeysListResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TokenKeyEndpoint
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SignerProvider signerProvider;

    public void setSignerProvider(SignerProvider signerProvider) {
        this.signerProvider = signerProvider;
    }

    @RequestMapping(value={"/token_key"}, method={RequestMethod.GET})
    @ResponseBody
    public VerificationKeyResponse getKey(Principal principal) {
        RSAPublicKey rsaKey;
        SignatureVerifier verifier;
        if ((principal == null || principal instanceof AnonymousAuthenticationToken) && !this.signerProvider.isPublic()) {
            throw new AccessDeniedException("You need to authenticate to see a shared key");
        }
        VerificationKeyResponse result = new VerificationKeyResponse();
        result.setAlgorithm(this.signerProvider.getSigner().algorithm());
        result.setKey(this.signerProvider.getVerifierKey());
        result.setType(this.signerProvider.getType());
        result.setUse("sig");
        if (this.signerProvider.isPublic() && "RSA".equals(this.signerProvider.getType()) && (verifier = this.signerProvider.getVerifier()) != null && verifier instanceof RsaVerifier && (rsaKey = this.extractRsaPublicKey((RsaVerifier)verifier)) != null) {
            String n = new String(Base64.encode((byte[])rsaKey.getModulus().toByteArray()));
            String e = new String(Base64.encode((byte[])rsaKey.getPublicExponent().toByteArray()));
            result.setModulus(n);
            result.setExponent(e);
        }
        return result;
    }

    @RequestMapping(value={"/token_keys"}, method={RequestMethod.GET})
    @ResponseBody
    public VerificationKeysListResponse getKeys(Principal principal) {
        VerificationKeysListResponse result = new VerificationKeysListResponse();
        result.setKeys(Collections.singletonList(this.getKey(principal)));
        return result;
    }

    private RSAPublicKey extractRsaPublicKey(RsaVerifier verifier) {
        try {
            Field f = verifier.getClass().getDeclaredField("key");
            if (f != null) {
                f.setAccessible(true);
                if (f.get(verifier) instanceof RSAPublicKey) {
                    return (RSAPublicKey)f.get(verifier);
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.signerProvider != null ? 1 : 0) != 0, (String)"A SignerProvider must be provided");
    }
}

