/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.util.MapCollector;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.StringUtils;

public class ScimGroupBootstrap
implements InitializingBean {
    private Map<String, String> groups;
    private Map<String, Set<String>> groupMembers;
    private Map<String, Set<String>> groupAdmins;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupMembershipManager membershipManager;
    private final ScimUserProvisioning scimUserProvisioning;
    private Map<String, String> defaultUserGroups = Collections.EMPTY_MAP;
    private Map<String, String> nonDefaultUserGroups = Collections.EMPTY_MAP;
    private Map<String, String> configuredGroups = Collections.EMPTY_MAP;
    private static final String USER_BY_NAME_FILTER = "username eq \"%s\"";
    private static final String GROUP_BY_NAME_FILTER = "displayName eq \"%s\"";
    private final Log logger = LogFactory.getLog(this.getClass());
    private PropertySource messageSource;
    private String messagePropertyNameTemplate = "scope.%s";
    private final MapCollector<String, String, String> collector = new MapCollector<String, String, String>(g -> g, g -> (String)this.getMessageSource().getProperty(String.format(this.messagePropertyNameTemplate, g)));

    public String getMessagePropertyNameTemplate() {
        return this.messagePropertyNameTemplate;
    }

    public void setMessagePropertyNameTemplate(String messagePropertyNameTemplate) {
        this.messagePropertyNameTemplate = messagePropertyNameTemplate;
    }

    public ScimGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimUserProvisioning scimUserProvisioning, ScimGroupMembershipManager membershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.scimUserProvisioning = scimUserProvisioning;
        this.membershipManager = membershipManager;
        this.groups = new HashMap<String, String>();
        this.groupMembers = new HashMap<String, Set<String>>();
        this.groupAdmins = new HashMap<String, Set<String>>();
    }

    public PropertySource getMessageSource() {
        if (this.messageSource == null) {
            String messagesFilename = "messages.properties";
            try {
                this.messageSource = new ResourcePropertySource(messagesFilename);
            }
            catch (IOException ex) {
                this.messageSource = new PropertySource.StubPropertySource(messagesFilename);
            }
        }
        return this.messageSource;
    }

    public void setMessageSource(PropertySource messageSource) {
        this.messageSource = messageSource;
    }

    public void setGroups(Map<String, String> groups) {
        if (groups == null) {
            groups = Collections.EMPTY_MAP;
        }
        groups.entrySet().forEach(e -> {
            if (!StringUtils.hasText((String)((String)e.getValue()))) {
                e.setValue((String)this.getMessageSource().getProperty(String.format(this.messagePropertyNameTemplate, e.getKey())));
            }
        });
        this.configuredGroups = groups;
        this.setCombinedGroups();
    }

    public void setDefaultUserGroups(Set<String> defaultUserGroups) {
        if (defaultUserGroups == null) {
            defaultUserGroups = Collections.EMPTY_SET;
        }
        this.defaultUserGroups = (Map)((Object)defaultUserGroups.stream().collect(this.collector));
        this.setCombinedGroups();
    }

    public void setNonDefaultUserGroups(Set<String> nonDefaultUserGroups) {
        if (nonDefaultUserGroups == null) {
            nonDefaultUserGroups = Collections.EMPTY_SET;
        }
        this.nonDefaultUserGroups = (Map)((Object)nonDefaultUserGroups.stream().collect(this.collector));
        this.setCombinedGroups();
    }

    private void setCombinedGroups() {
        this.groups = new HashMap<String, String>();
        this.groups.putAll(this.defaultUserGroups);
        this.groups.putAll(this.nonDefaultUserGroups);
        this.configuredGroups.entrySet().stream().filter(e -> StringUtils.hasText((String)((String)e.getValue())) || !this.groups.containsKey(e.getKey())).forEach(e -> this.groups.put((String)e.getKey(), (String)e.getValue()));
        this.groups = (Map)((Object)this.groups.entrySet().stream().collect(new MapCollector<Map.Entry, String, String>(e -> StringUtils.trimWhitespace((String)((String)e.getKey())), e -> StringUtils.trimWhitespace((String)((String)e.getValue())))));
    }

    public void setGroupMembers(List<String> membershipInfo) {
        for (String line : membershipInfo) {
            boolean groupAdmin;
            String[] fields = line.split("\\|");
            if (fields.length < 2) continue;
            Set users = StringUtils.commaDelimitedListToSet((String)fields[1]);
            String groupName = fields[0];
            this.groups.putIfAbsent(groupName, null);
            boolean bl = groupAdmin = 3 <= fields.length && "write".equalsIgnoreCase(fields[2]);
            if (groupAdmin) {
                this.groupAdmins.put(groupName, users);
                continue;
            }
            this.groupMembers.put(groupName, users);
        }
        this.logger.debug((Object)("groups: " + this.groups));
        this.logger.debug((Object)("admins: " + this.groupAdmins + ", members: " + this.groupMembers));
    }

    public void afterPropertiesSet() throws Exception {
        List groupInfos = this.groups.keySet().stream().filter(n -> StringUtils.hasText((String)n)).map(n -> this.getOrCreateGroup((String)n)).collect(Collectors.toList());
        for (int i = 0; i < groupInfos.size(); ++i) {
            ScimGroup g = (ScimGroup)groupInfos.get(i);
            String description = this.groups.get(g.getDisplayName());
            if (!StringUtils.hasText((String)description)) continue;
            g.setDescription(description);
            groupInfos.set(i, this.scimGroupProvisioning.update(g.getId(), g));
        }
        for (ScimGroup g : groupInfos) {
            this.addMembers(g);
        }
    }

    private void addMembers(ScimGroup group) {
        String name = group.getDisplayName();
        List<ScimGroupMember> members = this.getMembers(this.groupMembers.get(name), ScimGroupMember.GROUP_MEMBER);
        members.addAll(this.getMembers(this.groupAdmins.get(name), ScimGroupMember.GROUP_ADMIN));
        this.logger.debug((Object)("adding members: " + members + " into group: " + name));
        for (ScimGroupMember member : members) {
            try {
                this.membershipManager.addMember(group.getId(), member);
            }
            catch (MemberAlreadyExistsException ex) {
                this.logger.debug((Object)(member.getMemberId() + " already is member of group " + name));
            }
        }
    }

    private List<ScimGroupMember> getMembers(Set<String> names, List<ScimGroupMember.Role> auth) {
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ScimGroupMember> members = new ArrayList<ScimGroupMember>();
        for (String name : names) {
            ScimCore member = this.getScimResourceId(name);
            if (member == null) continue;
            members.add(new ScimGroupMember(member.getId(), member instanceof ScimGroup ? ScimGroupMember.Type.GROUP : ScimGroupMember.Type.USER, auth));
        }
        return members;
    }

    private ScimCore getScimResourceId(String name) {
        ScimUser res = this.getUser(name);
        if (res != null) {
            return res;
        }
        this.logger.debug((Object)("user " + name + " does not exist, checking in groups..."));
        return this.getGroup(name);
    }

    private ScimUser getUser(String name) {
        List user = this.scimUserProvisioning.query(String.format(USER_BY_NAME_FILTER, name));
        if (user != null && !user.isEmpty()) {
            return (ScimUser)user.get(0);
        }
        return null;
    }

    ScimGroup getGroup(String name) {
        List g = this.scimGroupProvisioning.query(String.format(GROUP_BY_NAME_FILTER, name));
        if (g != null && !g.isEmpty()) {
            ScimGroup gr = (ScimGroup)g.get(0);
            gr.setMembers(this.membershipManager.getMembers(gr.getId()));
            return gr;
        }
        this.logger.debug((Object)"could not find group with name");
        return null;
    }

    private ScimGroup getOrCreateGroup(String name) {
        this.logger.debug((Object)("adding group: " + name));
        ScimGroup g = new ScimGroup(null, name, IdentityZoneHolder.get().getId());
        try {
            g = this.scimGroupProvisioning.create(g);
        }
        catch (ScimResourceAlreadyExistsException ex) {
            this.logger.debug((Object)("group " + g + " already exists, retrieving..."));
            g = this.getGroup(name);
        }
        return g;
    }
}

