/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class UaaUrlUtils {
    public String getUaaUrl() {
        return UaaUrlUtils.getUaaUrl("");
    }

    public static String getUaaUrl(String path) {
        return UaaUrlUtils.getURIBuilder(path).build().toUriString();
    }

    public String getUaaHost() {
        return UaaUrlUtils.getURIBuilder("").build().getHost();
    }

    private static UriComponentsBuilder getURIBuilder(String path) {
        UriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentContextPath().path(path);
        return builder;
    }

    public static String findMatchingRedirectUri(Collection<String> wildcardUris, String requestedRedirectUri) {
        Set<Pattern> wildcards;
        if (wildcardUris != null && UaaStringUtils.matches(wildcards = UaaStringUtils.constructWildcards(wildcardUris), requestedRedirectUri)) {
            return requestedRedirectUri;
        }
        return null;
    }

    public static String getHostForURI(String uri) {
        UriComponentsBuilder b = UriComponentsBuilder.fromHttpUrl((String)uri);
        return b.build().getHost();
    }

    public static boolean isUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String addSubdomainToUrl(String url) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        builder.host(UaaUrlUtils.getSubdomain() + builder.build().getHost());
        return builder.build().toUriString();
    }

    public static String getSubdomain() {
        String subdomain = IdentityZoneHolder.get().getSubdomain();
        if (StringUtils.hasText((String)subdomain)) {
            subdomain = subdomain + ".";
        }
        return subdomain.trim();
    }

    public static String extractPathVariableFromUrl(int pathParameterIndex, String path) {
        String[] paths;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((paths = StringUtils.delimitedListToStringArray((String)path, (String)"/")).length != 0 && pathParameterIndex < paths.length) {
            return paths[pathParameterIndex];
        }
        return null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (servletPath == null) {
            servletPath = "";
        }
        if (pathInfo == null) {
            pathInfo = "";
        }
        String path = String.format("%s%s", servletPath, pathInfo);
        return path;
    }
}

