/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.util.StringUtils;

public class UaaAuthenticationDetails
implements Serializable {
    public static final String ADD_NEW = "add_new";
    public static final UaaAuthenticationDetails UNKNOWN = new UaaAuthenticationDetails();
    private boolean addNew;
    private final String origin;
    private String sessionId;
    private String clientId;

    private UaaAuthenticationDetails() {
        this.origin = "unknown";
        this.sessionId = "unknown";
        this.clientId = "unknown";
    }

    public UaaAuthenticationDetails(HttpServletRequest request) {
        this(request, null);
    }

    public UaaAuthenticationDetails(HttpServletRequest request, String clientId) {
        WebAuthenticationDetails webAuthenticationDetails = new WebAuthenticationDetails(request);
        this.origin = webAuthenticationDetails.getRemoteAddress();
        this.sessionId = webAuthenticationDetails.getSessionId();
        if (clientId == null) {
            String authHeader;
            this.clientId = request.getParameter("client_id");
            if (!StringUtils.hasText((String)this.clientId) && StringUtils.hasText((String)(authHeader = request.getHeader("Authorization"))) && authHeader.startsWith("Basic ")) {
                String decodedCredentials = new String(Base64.decode((String)authHeader.substring("Basic ".length())));
                String[] split = decodedCredentials.split(":");
                this.clientId = split[0];
            }
        } else {
            this.clientId = clientId;
        }
        this.addNew = Boolean.parseBoolean(request.getParameter(ADD_NEW));
    }

    public UaaAuthenticationDetails(@JsonProperty(value="addNew") boolean addNew, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="origin") String origin, @JsonProperty(value="sessionId") String sessionId) {
        this.addNew = addNew;
        this.clientId = clientId;
        this.origin = origin;
        this.sessionId = sessionId;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isAddNew() {
        return this.addNew;
    }

    public void setAddNew(boolean addNew) {
        this.addNew = addNew;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.origin != null) {
            sb.append("remoteAddress=").append(this.origin);
        }
        if (this.clientId != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("clientId=").append(this.clientId);
        }
        if (this.sessionId != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("sessionId=").append(this.sessionId);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UaaAuthenticationDetails other = (UaaAuthenticationDetails)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }
}

