/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.QueryableResourceManager;
import org.cloudfoundry.identity.uaa.resources.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.MultitenantJdbcClientDetailsService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.StringUtils;

public class JdbcQueryableClientDetailsService
extends AbstractQueryable<ClientDetails>
implements QueryableResourceManager<ClientDetails> {
    private static final Log logger = LogFactory.getLog(JdbcQueryableClientDetailsService.class);
    private MultitenantJdbcClientDetailsService delegate;
    private static final String CLIENT_FIELDS = "client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified";
    public static final String CLIENT_DETAILS_TABLE = "oauth_client_details";
    private static final String BASE_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details";

    public JdbcQueryableClientDetailsService(MultitenantJdbcClientDetailsService delegate, JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, new ClientDetailsRowMapper());
        this.delegate = delegate;
    }

    @Override
    protected String getBaseSqlQuery() {
        return BASE_FIND_STATEMENT;
    }

    @Override
    protected String getTableName() {
        return CLIENT_DETAILS_TABLE;
    }

    @Override
    public List<ClientDetails> query(String filter, String sortBy, boolean ascending) {
        this.getQueryConverter().convert(filter, sortBy, ascending);
        if (StringUtils.hasText((String)filter)) {
            filter = "(" + filter + ") and ";
        }
        filter = filter + " identity_zone_id eq \"" + IdentityZoneHolder.get().getId() + "\"";
        return super.query(filter, sortBy, ascending);
    }

    @Override
    public List<ClientDetails> retrieveAll() {
        return this.delegate.listClientDetails();
    }

    @Override
    public ClientDetails retrieve(String id) {
        return this.delegate.loadClientByClientId(id);
    }

    @Override
    public ClientDetails create(ClientDetails resource) {
        this.delegate.addClientDetails(resource);
        return this.delegate.loadClientByClientId(resource.getClientId());
    }

    @Override
    public ClientDetails update(String id, ClientDetails resource) {
        this.delegate.updateClientDetails(resource);
        return this.delegate.loadClientByClientId(id);
    }

    @Override
    public ClientDetails delete(String id, int version) {
        ClientDetails client = this.delegate.loadClientByClientId(id);
        this.delegate.removeClientDetails(id);
        return client;
    }

    @Override
    protected void validateOrderBy(String orderBy) throws IllegalArgumentException {
        super.validateOrderBy(orderBy, CLIENT_FIELDS);
    }

    private static class ClientDetailsRowMapper
    implements RowMapper<ClientDetails> {
        private ClientDetailsRowMapper() {
        }

        public ClientDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
            String scopes;
            String json;
            BaseClientDetails details = new BaseClientDetails(rs.getString(1), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(7), rs.getString(6));
            details.setClientSecret(rs.getString(2));
            if (rs.getObject(8) != null) {
                details.setAccessTokenValiditySeconds(Integer.valueOf(rs.getInt(8)));
            }
            if (rs.getObject(9) != null) {
                details.setRefreshTokenValiditySeconds(Integer.valueOf(rs.getInt(9)));
            }
            if ((json = rs.getString(10)) != null) {
                try {
                    Map additionalInformation = (Map)JsonUtils.readValue((String)json, Map.class);
                    details.setAdditionalInformation(additionalInformation);
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not decode JSON for additional information: " + details), (Throwable)e);
                }
            }
            if ((scopes = rs.getString(11)) != null) {
                details.setAutoApproveScopes((Collection)StringUtils.commaDelimitedListToSet((String)scopes));
            }
            if (rs.getTimestamp(12) != null) {
                details.addAdditionalInformation("lastModified", (Object)rs.getTimestamp(12));
            }
            return details;
        }
    }
}

