/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlSpAlreadyExistsException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/saml/service-providers"})
@RestController
public class SamlServiceProviderEndpoints {
    protected static Log logger = LogFactory.getLog(SamlServiceProviderEndpoints.class);
    private final SamlServiceProviderProvisioning serviceProviderProvisioning;
    private final SamlServiceProviderConfigurator samlConfigurator;

    public SamlServiceProviderEndpoints(SamlServiceProviderProvisioning serviceProviderProvisioning, SamlServiceProviderConfigurator samlConfigurator) {
        this.serviceProviderProvisioning = serviceProviderProvisioning;
        this.samlConfigurator = samlConfigurator;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<SamlServiceProvider> createServiceProvider(@RequestBody SamlServiceProvider body) throws MetadataProviderException {
        String zoneId = IdentityZoneHolder.get().getId();
        body.setIdentityZoneId(zoneId);
        this.samlConfigurator.addSamlServiceProvider(body);
        SamlServiceProvider createdSp = this.serviceProviderProvisioning.create(body);
        return new ResponseEntity((Object)createdSp, HttpStatus.CREATED);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<SamlServiceProvider> updateServiceProvider(@PathVariable String id, @RequestBody SamlServiceProvider body) throws MetadataProviderException {
        SamlServiceProvider existing = this.serviceProviderProvisioning.retrieve(id);
        String zoneId = IdentityZoneHolder.get().getId();
        body.setId(id);
        body.setIdentityZoneId(zoneId);
        if (!body.configIsValid()) {
            return new ResponseEntity(HttpStatus.UNPROCESSABLE_ENTITY);
        }
        body.setEntityId(existing.getEntityId());
        this.samlConfigurator.addSamlServiceProvider(body);
        SamlServiceProvider updatedSp = this.serviceProviderProvisioning.update(body);
        return new ResponseEntity((Object)updatedSp, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<SamlServiceProvider>> retrieveServiceProviders(@RequestParam(value="active_only", required=false) String activeOnly) {
        Boolean retrieveActiveOnly = Boolean.valueOf(activeOnly);
        List<SamlServiceProvider> serviceProviderList = this.serviceProviderProvisioning.retrieveAll(retrieveActiveOnly, IdentityZoneHolder.get().getId());
        return new ResponseEntity(serviceProviderList, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public ResponseEntity<SamlServiceProvider> retrieveServiceProvider(@PathVariable String id) {
        SamlServiceProvider serviceProvider = this.serviceProviderProvisioning.retrieve(id);
        return new ResponseEntity((Object)serviceProvider, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<SamlServiceProvider> deleteServiceProvider(@PathVariable String id) {
        SamlServiceProvider serviceProvider = this.serviceProviderProvisioning.retrieve(id);
        this.serviceProviderProvisioning.delete(id);
        return new ResponseEntity((Object)serviceProvider, HttpStatus.OK);
    }

    @ExceptionHandler(value={MetadataProviderException.class})
    public ResponseEntity<String> handleMetadataProviderException(MetadataProviderException e) {
        if (e.getMessage().contains("Duplicate")) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.CONFLICT);
        }
        return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={JsonUtils.JsonUtilException.class})
    public ResponseEntity<String> handleMetadataProviderException() {
        return new ResponseEntity((Object)"Invalid provider configuration.", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={EmptyResultDataAccessException.class})
    public ResponseEntity<String> handleProviderNotFoundException() {
        return new ResponseEntity((Object)"Provider not found.", HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={SamlSpAlreadyExistsException.class})
    public ResponseEntity<String> handleDuplicateServiceProvider() {
        return new ResponseEntity((Object)"SAML SP with the same entity id already exists.", HttpStatus.CONFLICT);
    }
}

