/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.Collection;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.util.SAMLUtil;

public class ZoneAwareMetadataGenerator
extends MetadataGenerator {
    public ExtendedMetadata generateExtendedMetadata() {
        ExtendedMetadata metadata = super.generateExtendedMetadata();
        metadata.setAlias(UaaUrlUtils.getSubdomain() + metadata.getAlias());
        return metadata;
    }

    public String getEntityId() {
        String entityId = super.getEntityId();
        if (UaaUrlUtils.isUrl(entityId)) {
            return UaaUrlUtils.addSubdomainToUrl(entityId);
        }
        return UaaUrlUtils.getSubdomain() + entityId;
    }

    public String getEntityBaseURL() {
        return UaaUrlUtils.addSubdomainToUrl(super.getEntityBaseURL());
    }

    protected String getEntityAlias() {
        return UaaUrlUtils.getSubdomain() + super.getEntityAlias();
    }

    public boolean isRequestSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isRequestSigned();
        }
        return super.isRequestSigned();
    }

    public boolean isWantAssertionSigned() {
        if (!IdentityZoneHolder.isUaa()) {
            return this.getZoneDefinition().getSamlConfig().isWantAssertionSigned();
        }
        return super.isWantAssertionSigned();
    }

    protected IdentityZoneConfiguration getZoneDefinition() {
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityZoneConfiguration definition = zone.getConfig();
        return definition != null ? definition : new IdentityZoneConfiguration();
    }

    public EntityDescriptor generateMetadata() {
        EntityDescriptor result = super.generateMetadata();
        result.setID(SAMLUtil.getNCNameString((String)result.getEntityID()));
        return result;
    }

    protected SPSSODescriptor buildSPSSODescriptor(String entityBaseURL, String entityAlias, boolean requestSigned, boolean wantAssertionSigned, Collection<String> includedNameID) {
        SPSSODescriptor result = super.buildSPSSODescriptor(entityBaseURL, entityAlias, requestSigned, wantAssertionSigned, includedNameID);
        int index = result.getAssertionConsumerServices().size();
        result.getAssertionConsumerServices().add(this.getAssertionConsumerService(this.getEntityBaseURL(), this.getEntityAlias(), false, index, "/oauth/token", "urn:oasis:names:tc:SAML:2.0:bindings:URI"));
        return result;
    }
}

