/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.uaa;

import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderConfigValidator;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.provider.PasswordPolicy;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;

public class UaaIdentityProviderConfigValidator
implements IdentityProviderConfigValidator {
    @Override
    public void validate(AbstractIdentityProviderDefinition definition) {
        if (definition == null) {
            return;
        }
        UaaIdentityProviderDefinition def = (UaaIdentityProviderDefinition)definition;
        PasswordPolicy passwordPolicy = def.getPasswordPolicy();
        LockoutPolicy lockoutPolicy = def.getLockoutPolicy();
        if (passwordPolicy == null && lockoutPolicy == null) {
            return;
        }
        boolean isValid = true;
        if (passwordPolicy != null) {
            isValid = passwordPolicy.allPresentAndPositive();
        }
        if (lockoutPolicy != null) {
            boolean bl = isValid = isValid && lockoutPolicy.allPresentAndPositive();
        }
        if (!isValid) {
            throw new IllegalArgumentException("Invalid Password/Lockout policy");
        }
    }
}

