/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UaaUser {
    private final String id;
    private final String username;
    private final String password;
    private final String email;
    private final String givenName;
    private final String familyName;
    private final Date created;
    private final Date modified;
    private final String origin;
    private final String externalId;
    private final String salt;
    private final Date passwordLastModified;
    private final String phoneNumber;
    private Long lastLogonTime;
    private Long previousLogonTime;
    private final String zoneId;
    private final List<? extends GrantedAuthority> authorities;
    private boolean verified = false;
    private boolean legacyVerificationBehavior = false;
    private boolean passwordChangeRequired;

    public String getZoneId() {
        return this.zoneId;
    }

    public UaaUser(String username, String password, String email, String givenName, String familyName) {
        this("NaN", username, password, email, UaaAuthority.USER_AUTHORITIES, givenName, familyName, new Date(), new Date(), null, null, false, null, null, new Date());
    }

    public UaaUser(String username, String password, String email, String givenName, String familyName, String origin, String zoneId) {
        this("NaN", username, password, email, UaaAuthority.USER_AUTHORITIES, givenName, familyName, new Date(), new Date(), origin, null, false, zoneId, null, new Date());
    }

    public UaaUser(String id, String username, String password, String email, List<? extends GrantedAuthority> authorities, String givenName, String familyName, Date created, Date modified, String origin, String externalId, boolean verified, String zoneId, String salt, Date passwordLastModified) {
        this(new UaaUserPrototype().withId(id).withUsername(username).withPassword(password).withEmail(email).withFamilyName(familyName).withGivenName(givenName).withCreated(created).withModified(modified).withAuthorities(authorities).withOrigin(origin).withExternalId(externalId).withVerified(verified).withZoneId(zoneId).withSalt(salt).withPasswordLastModified(passwordLastModified));
    }

    public UaaUser(UaaUserPrototype prototype) {
        Assert.hasText((String)prototype.getId(), (String)"Id cannot be null");
        Assert.hasText((String)prototype.getUsername(), (String)"Username cannot be empty");
        Assert.hasText((String)prototype.getEmail(), (String)"Email is required");
        this.id = prototype.getId();
        this.username = prototype.getUsername();
        this.password = prototype.getPassword();
        this.email = prototype.getEmail();
        this.familyName = prototype.getFamilyName();
        this.givenName = prototype.getGivenName();
        this.created = prototype.getCreated();
        this.modified = prototype.getModified();
        this.authorities = prototype.getAuthorities();
        this.origin = prototype.getOrigin();
        this.externalId = prototype.getExternalId();
        this.verified = prototype.isVerified();
        this.zoneId = prototype.getZoneId();
        this.salt = prototype.getSalt();
        this.passwordLastModified = prototype.getPasswordLastModified();
        this.phoneNumber = prototype.getPhoneNumber();
        this.legacyVerificationBehavior = prototype.isLegacyVerificationBehavior();
        this.passwordChangeRequired = prototype.isPasswordChangeRequired();
        this.lastLogonTime = prototype.getLastLogonTime();
        this.previousLogonTime = prototype.getPreviousLogonTime();
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getSalt() {
        return this.salt;
    }

    public List<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public UaaUser id(String id) {
        if (!"NaN".equals(this.id)) {
            throw new IllegalStateException("Id already set");
        }
        return new UaaUser(id, this.username, this.password, this.email, this.authorities, this.givenName, this.familyName, this.created, this.modified, this.origin, this.externalId, this.verified, this.zoneId, this.salt, this.passwordLastModified);
    }

    public UaaUser authorities(Collection<? extends GrantedAuthority> authorities) {
        ArrayList<? extends GrantedAuthority> values = new ArrayList<GrantedAuthority>(authorities);
        for (int i = 0; i < values.size(); ++i) {
            GrantedAuthority authority = values.get(i);
            values.set(i, (GrantedAuthority)UaaAuthority.authority(authority.toString()));
        }
        if (!values.contains((Object)UaaAuthority.UAA_USER)) {
            values.add(UaaAuthority.UAA_USER);
        }
        UaaUser user = new UaaUser(this.id, this.username, this.password, this.email, values, this.givenName, this.familyName, this.created, this.modified, this.origin, this.externalId, this.verified, this.zoneId, this.salt, this.passwordLastModified);
        return user;
    }

    public String toString() {
        return "[UaaUser {id=" + this.id + ", username=" + this.username + ", email=" + this.email + ", givenName=" + this.givenName + ", familyName=" + this.familyName + "}]";
    }

    public Date getModified() {
        return this.modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getPasswordLastModified() {
        return this.passwordLastModified;
    }

    public UaaUser modifySource(String origin, String externalId) {
        return new UaaUser(new UaaUserPrototype().withEmail(this.email).withGivenName(this.givenName).withFamilyName(this.familyName).withPhoneNumber(this.phoneNumber).withModified(this.modified).withId(this.id).withUsername(this.username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(origin).withExternalId(externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public UaaUser modifyEmail(String email) {
        return new UaaUser(new UaaUserPrototype().withEmail(email).withGivenName(this.givenName).withFamilyName(this.familyName).withPhoneNumber(this.phoneNumber).withModified(this.modified).withId(this.id).withUsername(this.username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(this.origin).withExternalId(this.externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public UaaUser modifyOrigin(String origin) {
        return new UaaUser(new UaaUserPrototype().withEmail(this.email).withGivenName(this.givenName).withFamilyName(this.familyName).withPhoneNumber(this.phoneNumber).withModified(this.modified).withId(this.id).withUsername(this.username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(origin).withExternalId(this.externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public UaaUser modifyId(String id) {
        return new UaaUser(new UaaUserPrototype().withEmail(this.email).withGivenName(this.givenName).withFamilyName(this.familyName).withPhoneNumber(this.phoneNumber).withModified(this.modified).withId(id).withUsername(this.username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(this.origin).withExternalId(this.externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public UaaUser modifyUsername(String username) {
        return new UaaUser(new UaaUserPrototype().withEmail(this.email).withGivenName(this.givenName).withFamilyName(this.familyName).withPhoneNumber(this.phoneNumber).withModified(this.modified).withId(this.id).withUsername(username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(this.origin).withExternalId(this.externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public UaaUser modifyAttributes(String email, String givenName, String familyName, String phoneNumber) {
        return new UaaUser(new UaaUserPrototype().withEmail(email).withGivenName(givenName).withFamilyName(familyName).withPhoneNumber(phoneNumber).withModified(this.modified).withId(this.id).withUsername(this.username).withPassword(this.password).withAuthorities(this.authorities).withCreated(this.created).withOrigin(this.origin).withExternalId(this.externalId).withVerified(this.verified).withZoneId(this.zoneId).withSalt(this.salt).withPasswordLastModified(this.passwordLastModified));
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isLegacyVerificationBehavior() {
        return this.legacyVerificationBehavior;
    }

    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    public Long getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(Long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    public Long getPreviousLogonTime() {
        return this.previousLogonTime;
    }

    public void setPreviousLogonTime(Long previousLogonTime) {
        this.previousLogonTime = previousLogonTime;
    }
}

