/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.audit.event.ApprovalModifiedEvent;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SearchQueryConverter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class JdbcApprovalStore
implements ApprovalStore,
ApplicationEventPublisherAware {
    private final JdbcTemplate jdbcTemplate;
    private JdbcPagingListFactory pagingListFactory;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final SearchQueryConverter queryConverter;
    private final RowMapper<Approval> rowMapper = new AuthorizationRowMapper();
    private static final String TABLE_NAME = "authz_approvals";
    private static final String FIELDS = "user_id,client_id,scope,expiresAt,status,lastModifiedAt";
    private static final String ADD_AUTHZ_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?)", "authz_approvals", "user_id,client_id,scope,expiresAt,status,lastModifiedAt");
    private static final String REFRESH_AUTHZ_SQL = String.format("update %s set lastModifiedAt=?, expiresAt=?, status=? where user_id=? and client_Id=? and scope=?", "authz_approvals");
    private static final String GET_AUTHZ_SQL = String.format("select %s from %s", "user_id,client_id,scope,expiresAt,status,lastModifiedAt", "authz_approvals");
    private static final String DELETE_AUTHZ_SQL = String.format("delete from %s", "authz_approvals");
    private static final String EXPIRE_AUTHZ_SQL = String.format("update %s set expiresAt = :expiry", "authz_approvals");
    private boolean handleRevocationsAsExpiry = false;
    private ApplicationEventPublisher applicationEventPublisher;

    public JdbcApprovalStore(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory, SearchQueryConverter queryConverter) {
        Assert.notNull((Object)jdbcTemplate);
        Assert.notNull((Object)queryConverter);
        this.jdbcTemplate = jdbcTemplate;
        this.queryConverter = queryConverter;
        this.pagingListFactory = pagingListFactory;
    }

    public void setHandleRevocationsAsExpiry(boolean handleRevocationsAsExpiry) {
        this.handleRevocationsAsExpiry = handleRevocationsAsExpiry;
    }

    public boolean refreshApproval(final Approval approval) {
        this.logger.debug((Object)String.format("refreshing approval: [%s]", approval));
        int refreshed = this.jdbcTemplate.update(REFRESH_AUTHZ_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setTimestamp(1, new Timestamp(approval.getLastUpdatedAt().getTime()));
                ps.setTimestamp(2, new Timestamp(approval.getExpiresAt().getTime()));
                ps.setString(3, (approval.getStatus() == null ? Approval.ApprovalStatus.APPROVED : approval.getStatus()).toString());
                ps.setString(4, approval.getUserId());
                ps.setString(5, approval.getClientId());
                ps.setString(6, approval.getScope());
            }
        });
        if (refreshed != 1) {
            throw new DataIntegrityViolationException("Attempt to refresh non-existent authorization");
        }
        return true;
    }

    @Override
    public boolean addApproval(final Approval approval) {
        block2: {
            this.logger.debug((Object)String.format("adding approval: [%s]", approval));
            try {
                this.refreshApproval(approval);
            }
            catch (DataIntegrityViolationException ex) {
                int count = this.jdbcTemplate.update(ADD_AUTHZ_SQL, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, approval.getUserId());
                        ps.setString(2, approval.getClientId());
                        ps.setString(3, approval.getScope());
                        ps.setTimestamp(4, new Timestamp(approval.getExpiresAt().getTime()));
                        ps.setString(5, (approval.getStatus() == null ? Approval.ApprovalStatus.APPROVED : approval.getStatus()).toString());
                        ps.setTimestamp(6, new Timestamp(approval.getLastUpdatedAt().getTime()));
                    }
                });
                if (count != 0) break block2;
                throw new EmptyResultDataAccessException("Approval add failed", 1);
            }
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.publish(new ApprovalModifiedEvent(approval, authentication));
        return true;
    }

    @Override
    public boolean revokeApproval(Approval approval) {
        return this.revokeApprovals(String.format("user_id eq \"%s\" and client_id eq \"%s\" and scope eq \"%s\"", approval.getUserId(), approval.getClientId(), approval.getScope()));
    }

    @Override
    public boolean revokeApprovals(String filter) {
        Map<String, Object> sqlParams;
        String sql;
        SearchQueryConverter.ProcessedFilter where = this.queryConverter.convert(filter, null, true);
        this.logger.debug((Object)String.format("Filtering approvals with filter: [%s]", where));
        if (this.handleRevocationsAsExpiry) {
            sql = EXPIRE_AUTHZ_SQL + " where " + where.getSql();
            sqlParams = where.getParams();
            sqlParams.put("expiry", new Timestamp(new Date().getTime() - 1L));
        } else {
            sql = DELETE_AUTHZ_SQL + " where " + where.getSql();
            sqlParams = where.getParams();
        }
        try {
            int revoked = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).update(sql, sqlParams);
            this.logger.debug((Object)String.format("revoked [%d] approvals matching sql: [%s]", revoked, where));
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)("Error expiring approvals, possible invalid filter: " + where), (Throwable)ex);
            throw new IllegalArgumentException("Error revoking approvals");
        }
        return true;
    }

    public boolean purgeExpiredApprovals() {
        this.logger.debug((Object)"Purging expired approvals from database");
        try {
            int deleted = this.jdbcTemplate.update(DELETE_AUTHZ_SQL + " where expiresAt <= ?", ps -> ps.setTimestamp(1, new Timestamp(new Date().getTime())));
            this.logger.debug((Object)(deleted + " expired approvals deleted"));
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)"Error purging expired approvals", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public List<Approval> getApprovals(String filter) {
        SearchQueryConverter.ProcessedFilter where = this.queryConverter.convert(filter, null, true);
        this.logger.debug((Object)String.format("Filtering approvals with filter: [%s]", where));
        try {
            return this.pagingListFactory.createJdbcPagingList(GET_AUTHZ_SQL + " where " + where.getSql(), where.getParams(), this.rowMapper, 200);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("Error filtering approvals with filter: " + where), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
    }

    @Override
    public List<Approval> getApprovals(String userId, String clientId) {
        return this.getApprovals(String.format("user_id eq \"%s\" and client_id eq \"%s\"", userId, clientId));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publish(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    private static class AuthorizationRowMapper
    implements RowMapper<Approval> {
        private AuthorizationRowMapper() {
        }

        public Approval mapRow(ResultSet rs, int rowNum) throws SQLException {
            String userName = rs.getString(1);
            String clientId = rs.getString(2);
            String scope = rs.getString(3);
            Timestamp expiresAt = rs.getTimestamp(4);
            String status = rs.getString(5);
            Timestamp lastUpdatedAt = rs.getTimestamp(6);
            Approval approval = new Approval().setUserId(userName).setClientId(clientId).setScope(scope).setExpiresAt((Date)expiresAt).setStatus(Approval.ApprovalStatus.valueOf((String)status)).setLastUpdatedAt((Date)lastUpdatedAt);
            return approval;
        }
    }
}

