/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.List;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.cloudfoundry.identity.uaa.authentication.manager.LockoutPolicyRetriever;
import org.cloudfoundry.identity.uaa.authentication.manager.LoginPolicy;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.util.TimeService;

public class CommonLoginPolicy
implements LoginPolicy {
    private final UaaAuditService auditService;
    private final LockoutPolicyRetriever lockoutPolicyRetriever;
    private final AuditEventType successEventType;
    private final AuditEventType failureEventType;
    private final TimeService timeService;
    private final boolean enabled;

    public CommonLoginPolicy(UaaAuditService auditService, LockoutPolicyRetriever lockoutPolicyRetriever, AuditEventType successEventType, AuditEventType failureEventType, TimeService timeService, boolean enabled) {
        this.auditService = auditService;
        this.lockoutPolicyRetriever = lockoutPolicyRetriever;
        this.successEventType = successEventType;
        this.failureEventType = failureEventType;
        this.timeService = timeService;
        this.enabled = enabled;
    }

    @Override
    public LoginPolicy.Result isAllowed(String principalId) {
        int failureCount = 0;
        if (this.enabled) {
            AuditEvent lastFailure;
            LockoutPolicy lockoutPolicy = this.lockoutPolicyRetriever.getLockoutPolicy();
            long eventsAfter = this.timeService.getCurrentTimeMillis() - (long)(lockoutPolicy.getCountFailuresWithin() * 1000);
            List<AuditEvent> events = this.auditService.find(principalId, eventsAfter);
            failureCount = this.sequentialFailureCount(events);
            if (failureCount >= lockoutPolicy.getLockoutAfterFailures() && (lastFailure = this.mostRecentFailure(events)) != null && lastFailure.getTime() > this.timeService.getCurrentTimeMillis() - (long)(lockoutPolicy.getLockoutPeriodSeconds() * 1000)) {
                return new LoginPolicy.Result(false, failureCount);
            }
        }
        return new LoginPolicy.Result(true, failureCount);
    }

    private int sequentialFailureCount(List<AuditEvent> events) {
        int failureCount = 0;
        for (AuditEvent event : events) {
            if (event.getType() == this.failureEventType) {
                ++failureCount;
                continue;
            }
            if (event.getType() != this.successEventType) continue;
            break;
        }
        return failureCount;
    }

    private AuditEvent mostRecentFailure(List<AuditEvent> events) {
        for (AuditEvent event : events) {
            if (event.getType() != this.failureEventType) continue;
            return event;
        }
        return null;
    }

    @Override
    public LockoutPolicyRetriever getLockoutPolicyRetriever() {
        return this.lockoutPolicyRetriever;
    }
}

