/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.cloudfoundry.identity.uaa.impl.config.LegacyTokenKey;
import org.cloudfoundry.identity.uaa.oauth.jwt.CommonSignatureVerifier;
import org.cloudfoundry.identity.uaa.oauth.jwt.CommonSigner;
import org.cloudfoundry.identity.uaa.oauth.jwt.Signer;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyInfo {
    private static Pattern PEM_DATA = Pattern.compile("-----BEGIN (.*)-----(.*)-----END (.*)-----", 32);
    private static final Base64.Encoder base64encoder = Base64.getMimeEncoder(64, "\n".getBytes());
    private String keyId;
    private String verifierKey;
    private String signingKey;
    private Signer signer;
    private SignatureVerifier verifier;
    private String type;
    private java.security.interfaces.RSAPublicKey rsaPublicKey;

    public KeyInfo() {
        this.signingKey = this.verifierKey = new RandomValueStringGenerator().generate();
        this.signer = new CommonSigner(null, this.verifierKey);
        this.verifier = new MacSigner(this.signingKey);
        this.type = "MAC";
    }

    public static KeyInfo getKey(String keyId) {
        return KeyInfo.getKeys().get(keyId);
    }

    public static Map<String, KeyInfo> getKeys() {
        IdentityZoneConfiguration config = IdentityZoneHolder.get().getConfig();
        if (config == null || config.getTokenPolicy().getKeys() == null || config.getTokenPolicy().getKeys().isEmpty()) {
            config = IdentityZoneHolder.getUaaZone().getConfig();
        }
        HashMap<String, KeyInfo> keys = new HashMap<String, KeyInfo>();
        for (Map.Entry entry : config.getTokenPolicy().getKeys().entrySet()) {
            KeyInfo keyInfo = new KeyInfo();
            keyInfo.setKeyId((String)entry.getKey());
            keyInfo.setSigningKey((String)entry.getValue());
            keys.put((String)entry.getKey(), keyInfo);
        }
        if (keys.isEmpty()) {
            keys.put("legacy-token-key", LegacyTokenKey.getLegacyTokenKeyInfo());
        }
        return keys;
    }

    public static KeyInfo getActiveKey() {
        return KeyInfo.getKeys().get(KeyInfo.getActiveKeyId());
    }

    private static String getActiveKeyId() {
        Map<String, KeyInfo> keys;
        IdentityZoneConfiguration config = IdentityZoneHolder.get().getConfig();
        if (config == null) {
            return IdentityZoneHolder.getUaaZone().getConfig().getTokenPolicy().getActiveKeyId();
        }
        String activeKeyId = config.getTokenPolicy().getActiveKeyId();
        if (!StringUtils.hasText((String)activeKeyId) && (keys = KeyInfo.getKeys()).size() == 1) {
            activeKeyId = (String)keys.keySet().stream().findAny().get();
        }
        if (!StringUtils.hasText((String)activeKeyId)) {
            activeKeyId = IdentityZoneHolder.getUaaZone().getConfig().getTokenPolicy().getActiveKeyId();
        }
        if (!StringUtils.hasText((String)activeKeyId)) {
            activeKeyId = "legacy-token-key";
        }
        return activeKeyId;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public String getVerifierKey() {
        return this.verifierKey;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public String getType() {
        return this.type;
    }

    public java.security.interfaces.RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public boolean isAssymetricKey() {
        return KeyInfo.isAssymetricKey(this.verifierKey);
    }

    public SignatureVerifier getVerifier() {
        return this.verifier;
    }

    public static boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }

    public void setSigningKey(String signingKey) {
        if (StringUtils.isEmpty((Object)signingKey)) {
            throw new IllegalArgumentException("Signing key cannot be empty");
        }
        Assert.hasText((String)signingKey);
        this.signingKey = signingKey = signingKey.trim();
        this.signer = new CommonSigner(this.keyId, signingKey);
        if (KeyInfo.isAssymetricKey(signingKey)) {
            KeyPair keyPair = KeyInfo.parseKeyPair(signingKey);
            this.rsaPublicKey = (java.security.interfaces.RSAPublicKey)keyPair.getPublic();
            this.verifierKey = KeyInfo.pemEncodePublicKey(this.rsaPublicKey);
            this.type = "RSA";
        } else {
            this.verifierKey = signingKey;
            this.type = "MAC";
        }
        this.verifier = new CommonSignatureVerifier(this.verifierKey);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        if (!StringUtils.hasText((String)keyId)) {
            throw new IllegalArgumentException("KeyId should not be null or empty");
        }
        this.keyId = keyId;
        this.signer = new CommonSigner(keyId, this.signingKey);
    }

    public static KeyPair parseKeyPair(String pemData) {
        Matcher m = PEM_DATA.matcher(pemData.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("String is not PEM encoded data");
        }
        String type = m.group(1);
        byte[] content = Codecs.b64Decode((byte[])Codecs.utf8Encode((CharSequence)m.group(2)));
        PrivateKey privateKey = null;
        try {
            PublicKey publicKey;
            KeyFactory fact = KeyFactory.getInstance("RSA");
            if (type.equals("RSA PRIVATE KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                if (seq.size() != 9) {
                    throw new IllegalArgumentException("Invalid RSA Private Key ASN1 sequence.");
                }
                RSAPrivateKey key = RSAPrivateKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                RSAPrivateCrtKeySpec privSpec = new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrime1(), key.getPrime2(), key.getExponent1(), key.getExponent2(), key.getCoefficient());
                publicKey = fact.generatePublic(pubSpec);
                privateKey = fact.generatePrivate(privSpec);
            } else if (type.equals("PUBLIC KEY")) {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(content);
                publicKey = fact.generatePublic(keySpec);
            } else if (type.equals("RSA PUBLIC KEY")) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)content);
                RSAPublicKey key = RSAPublicKey.getInstance((Object)seq);
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
                publicKey = fact.generatePublic(pubSpec);
            } else {
                throw new IllegalArgumentException(type + " is not a supported format");
            }
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String pemEncodePublicKey(PublicKey publicKey) {
        String begin = "-----BEGIN PUBLIC KEY-----\n";
        String end = "\n-----END PUBLIC KEY-----";
        byte[] data = publicKey.getEncoded();
        String base64encoded = new String(base64encoder.encode(data));
        return begin + base64encoded + end;
    }
}

