/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import org.apache.commons.logging.Log;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.springframework.context.ApplicationListener;

public interface SamlServiceProviderDeletable
extends ApplicationListener<EntityDeletedEvent<?>> {
    default public void onApplicationEvent(EntityDeletedEvent<?> event) {
        if (event == null || event.getDeleted() == null) {
            return;
        }
        if (event.getDeleted() instanceof SamlServiceProvider) {
            String entityId = ((SamlServiceProvider)event.getDeleted()).getEntityId();
            String zoneId = ((SamlServiceProvider)event.getDeleted()).getIdentityZoneId();
            this.deleteByEntityId(entityId, zoneId);
        } else {
            this.getLogger().debug((Object)("Unsupported deleted event for deletion of object:" + event.getDeleted()));
        }
    }

    default public boolean isUaaZone(String zoneId) {
        return IdentityZone.getUaa().getId().equals(zoneId);
    }

    public int deleteByEntityId(String var1, String var2);

    public int deleteByIdentityZone(String var1);

    public Log getLogger();
}

