/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalsService;
import org.cloudfoundry.identity.uaa.approval.DescribedApproval;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ProfileController {
    protected static Log logger = LogFactory.getLog(ProfileController.class);
    private final ApprovalsService approvalsService;
    private final ClientDetailsService clientDetailsService;

    @Autowired
    public ProfileController(ApprovalsService approvalsService, ClientDetailsService clientDetailsService) {
        this.approvalsService = approvalsService;
        this.clientDetailsService = clientDetailsService;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.GET})
    public String get(Authentication authentication, Model model) {
        Map<String, List<DescribedApproval>> approvals = this.approvalsService.getCurrentApprovalsByClientId();
        Map<String, String> clientNames = this.getClientNames(approvals);
        model.addAttribute("clientnames", clientNames);
        model.addAttribute("approvals", approvals);
        model.addAttribute("isUaaManagedUser", (Object)this.isUaaManagedUser(authentication));
        return "approvals";
    }

    protected Map<String, String> getClientNames(Map<String, List<DescribedApproval>> approvals) {
        LinkedHashMap<String, String> clientNames = new LinkedHashMap<String, String>();
        for (String clientId : approvals.keySet()) {
            ClientDetails details = this.clientDetailsService.loadClientByClientId(clientId);
            String name = details.getClientId();
            if (details.getAdditionalInformation() != null && details.getAdditionalInformation().get("name") != null) {
                name = (String)details.getAdditionalInformation().get("name");
            }
            clientNames.put(clientId, name);
        }
        return clientNames;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.POST})
    public String post(@RequestParam(required=false) Collection<String> checkedScopes, @RequestParam(required=false) String update, @RequestParam(required=false) String delete, @RequestParam(required=false) String clientId) {
        if (null != update) {
            Map<String, List<DescribedApproval>> approvalsByClientId = this.approvalsService.getCurrentApprovalsByClientId();
            ArrayList<DescribedApproval> allApprovals = new ArrayList<DescribedApproval>();
            for (List<DescribedApproval> list : approvalsByClientId.values()) {
                allApprovals.addAll(list);
            }
            for (Approval approval : allApprovals) {
                String namespacedScope = approval.getClientId() + "-" + approval.getScope();
                if (checkedScopes != null && checkedScopes.contains(namespacedScope)) {
                    approval.setStatus(Approval.ApprovalStatus.APPROVED);
                    continue;
                }
                approval.setStatus(Approval.ApprovalStatus.DENIED);
            }
            this.approvalsService.updateApprovals(allApprovals);
        } else if (null != delete) {
            this.approvalsService.deleteApprovalsForClient(clientId);
        }
        return "redirect:profile";
    }

    @ExceptionHandler
    public View handleException(NoSuchClientException nsce) {
        logger.debug((Object)("Unable to find client for approvals:" + nsce.getMessage()));
        return new RedirectView("profile?error_message_code=request.invalid_parameter", true);
    }

    private boolean isUaaManagedUser(Authentication authentication) {
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            UaaPrincipal principal = (UaaPrincipal)authentication.getPrincipal();
            return "uaa".equals(principal.getOrigin());
        }
        return false;
    }
}

